/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

public class ActiveObject
extends Thread {
    private static int id = 1;
    private boolean killed = false;
    private static final ThreadGroup GROUP = new ThreadGroup("ObjectDraw");

    public static void killAll() {
        Thread[] threads = new Thread[GROUP.activeCount() + 20];
        int length = GROUP.enumerate(threads);
        int i = 0;
        while (i < length) {
            ((ActiveObject)threads[i]).kill();
            ++i;
        }
    }

    @Override
    public void run() {
        super.run();
    }

    @Override
    public void start() {
        super.start();
    }

    public void kill() {
        this.killed = true;
        this.interrupt();
    }

    private static void checkKilled() {
        Thread active = Thread.currentThread();
        if (active instanceof ActiveObject && ((ActiveObject)active).killed) {
            throw new ThreadDeath();
        }
    }

    public static void yield() {
        ActiveObject.checkKilled();
        Thread.yield();
        ActiveObject.checkKilled();
    }

    public static void pause(long millis, int nanos) {
        ActiveObject.checkKilled();
        try {
            Thread.sleep(millis, nanos);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ActiveObject.checkKilled();
    }

    public static void pause(double millis) {
        ActiveObject.pause((long)millis, 0);
    }

    public static void pause(long millis) {
        ActiveObject.pause(millis, 0);
    }

    public ActiveObject() {
        this("ActiveObject" + id++);
    }

    public ActiveObject(String name) {
        super(GROUP, name);
    }

    public ActiveObject(Runnable target) {
        this(target, "ActiveObject" + id++);
    }

    public ActiveObject(Runnable target, String name) {
        super(GROUP, target, name);
    }
}

