/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.DrawableInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.EventTimer;
import coffeedraw.Location;
import coffeedraw.ObjectDrawShape;
import coffeedraw.PathMeasurer;
import coffeedraw.Text;
import coffeedraw.VisibleImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class Animation
extends ObjectDrawShape
implements Serializable {
    private final ArrayList labels = new ArrayList();
    private final ArrayList specialRegions = new ArrayList();
    private final AnimationType type;
    private final Color[] labelColors = new Color[10];
    private Particle[] particles;
    private final ObjectDrawShape basis;
    private int count = 1;
    private int frame;
    private boolean cancelled = false;
    private boolean firstLabelRender = true;
    private final int dx;
    private final int dy;
    private final DrawingCanvas oldCanvas;
    private boolean attached = defaultAttached;
    private static final List animations = Collections.synchronizedList(new ArrayList());
    private static final EventTimer timer = new EventTimer(new AnimationRunner(), "step");
    private static final Font LABEL_FONT = Text.DEFAULT_FONT.deriveFont(1, 24.0f);
    private static final Image[] blood;
    private static final Image[] smoke;
    private static final Image[] steam;
    private static final Image[] steam2;
    private static final Image[] explosion;
    private static final Image[] soot;
    private static final Image[] lightning;
    private static final Image[] spark;
    private static final Image[] green;
    private static final Image[] darkGreen;
    private static final Image[] limeGreen;
    private static final Image[] white;
    private static final Image[] purple;
    private static final Image[] rightArc;
    private static final Image[] leftArc;
    private static final Image[] pinkRightArc;
    private static final Image[] hailstone;
    private static final Image[] asteroid;
    private static Color defaultLabelColor;
    private static boolean defaultAttached;
    public static final AnimationType METEORS;
    public static final AnimationType METEOR;
    public static final AnimationType SLASH_RIGHT;
    public static final AnimationType SLASH_LEFT;
    public static final AnimationType SMOKE_BOMB;
    public static final AnimationType GLOW;
    public static final AnimationType DUSTY;
    public static final AnimationType SPARKLY;
    public static final AnimationType FROSTY;
    public static final AnimationType ICE_STORM;
    public static final AnimationType TREASURE;
    public static final AnimationType SHIELD;
    public static final AnimationType BURST;
    public static final AnimationType SPARKS;
    public static final AnimationType GOLD_SHOWER;
    public static final AnimationType SPLIT;
    public static final AnimationType SWIRL;
    public static final AnimationType SWARM;
    public static final AnimationType LIGHTNING;

    static {
        defaultLabelColor = DEFAULT_COLOR;
        defaultAttached = true;
        METEORS = new MeteorAnimationType();
        METEOR = new SingleMeteorAnimationType();
        SLASH_RIGHT = new BloodAnimationType(1);
        SLASH_LEFT = new BloodAnimationType(-1);
        SMOKE_BOMB = new SimpleAnimationType(40){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[100];
                int i = 0;
                while (i < particles.length) {
                    double y;
                    double x = -25.0 + Math.random() * 50.0;
                    if (x * x + (y = -35.0 + Math.random() * 50.0) * y > 625.0) continue;
                    particles[i++] = new Particle(x, y, 2.5 - 5.0 * Math.random(), 1.0 - 7.0 * Math.random(), (int)(Math.random() * 20.0), smoke[0]);
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if (frame >= 40 || particle.y > 30.0) {
                    particle.image = null;
                } else {
                    particle.vx = 0.8 * particle.vx + 2.0 * Math.random() - 1.0;
                    particle.vy = 0.8 * particle.vy + 2.0 * Math.random() - 0.75;
                    if (frame > 30) {
                        particle.image = smoke[frame - 30];
                    }
                }
            }
        };
        GLOW = new SimpleAnimationType(60){

            @Override
            Location getLocation(DrawableInterface object) {
                return Animation.getOrigin(object);
            }

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = this.outline(animation.basis, 1.2, green[0]);
                int i = 0;
                while (i < particles.length) {
                    Particle p = particles[i];
                    p.t = (int)(Math.random() * 30.0);
                    p.vy = 0.0;
                    p.vx = 0.0;
                    ++i;
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) < 0 || frame >= 30) {
                    particle.image = null;
                    return;
                }
                if (frame < 20) {
                    particle.image = green[frame < 9 ? 9 - frame : 0];
                } else if (frame == 20) {
                    particle.vx = Math.random() - 0.5;
                    particle.vy = -4.0 - 2.0 * Math.random();
                    particle.image = green[0];
                } else {
                    particle.vx = 0.8 * particle.vx + 0.5 * Math.random() - 0.25;
                    particle.vy = 0.8 * particle.vy + 0.5 * Math.random() - 0.25;
                    particle.image = green[frame - 20];
                }
            }
        };
        DUSTY = new SimpleAnimationType(90){

            @Override
            Location getLocation(DrawableInterface object) {
                return Animation.getOrigin(object);
            }

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = this.outline(animation.basis, 0.75, soot[0]);
                int i = 0;
                while (i < particles.length) {
                    Particle p = particles[i];
                    p.t = (int)(Math.random() * 20.0 + Math.random() * 20.0 + Math.random() * 20.0);
                    p.vx *= 0.3;
                    p.vy *= 0.3;
                    ++i;
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) < 0 || frame >= 30) {
                    particle.image = null;
                    return;
                }
                particle.image = soot[frame / 3];
            }
        };
        SPARKLY = new SimpleAnimationType(90){

            @Override
            Location getLocation(DrawableInterface object) {
                return Animation.getOrigin(object);
            }

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = this.outline(animation.basis, 0.75, spark[0]);
                int i = 0;
                while (i < particles.length) {
                    Particle p = particles[i];
                    p.t = (int)(Math.random() * 20.0 + Math.random() * 20.0 + Math.random() * 20.0);
                    p.vx *= 0.3;
                    p.vy *= 0.3;
                    ++i;
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) < 0 || frame >= 30) {
                    particle.image = null;
                    return;
                }
                particle.image = spark[frame / 3];
            }
        };
        FROSTY = new SimpleAnimationType(90){

            @Override
            Location getLocation(DrawableInterface object) {
                return Animation.getOrigin(object);
            }

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = this.outline(animation.basis, 0.75, white[0]);
                int i = 0;
                while (i < particles.length) {
                    Particle p = particles[i];
                    p.t = (int)(Math.random() * 20.0 + Math.random() * 20.0 + Math.random() * 20.0);
                    p.vx *= 0.3;
                    p.vy *= 0.3;
                    ++i;
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) < 0 || frame >= 30) {
                    particle.image = null;
                    return;
                }
                particle.image = white[frame / 3];
            }
        };
        ICE_STORM = new SimpleAnimationType(70){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[600];
                int i = 0;
                while (i < particles.length) {
                    int e;
                    double angle = Math.random() * Math.PI * 2.0;
                    double r = 0.5 + Math.random();
                    double target_x = 50.0 * Math.cos(angle) * r;
                    double target_y = 60.0 * Math.sin(angle) * r;
                    double vx = 8.0 * Math.random() - 4.0;
                    double vy = 8.0 + 4.0 * Math.random();
                    int t = (int)(Math.random() * 10.0) * 4;
                    double x = target_x - 20.0 * vx;
                    double y = target_y - 20.0 * vy;
                    particles[i++] = new Particle(x, y, vx, vy, t, hailstone[0]);
                    if (animation.isSpecial(target_x, target_y)) {
                        e = 0;
                        while (e < 9) {
                            double rad = Math.random() * Math.PI * 2.0;
                            double speed = Math.random() * 6.0 + 1.0;
                            particles[i++] = new Particle(target_x, target_y, speed * Math.sin(rad), speed * Math.cos(rad), t + 22 + (int)Math.random() * 2, steam[0]);
                            ++e;
                        }
                        continue;
                    }
                    e = 0;
                    while (e < 9) {
                        particles[i++] = new Particle(target_x, target_y, Math.random() * 6.0 - 3.0, -5.0 - 2.0 * Math.random(), t + 21, white[0]);
                        ++e;
                    }
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t & 0xFFFFFFFC) < 0 || frame >= 20) {
                    particle.image = null;
                    return;
                }
                switch (particle.t & 3) {
                    case 1: {
                        if (frame >= 10) {
                            particle.vy = 0.0;
                            particle.vx *= 0.85;
                        } else {
                            particle.vy += 1.0;
                        }
                        particle.image = frame > 10 ? white[frame - 10] : white[0];
                        return;
                    }
                    case 2: 
                    case 3: {
                        particle.vx = 0.8 * particle.vx + Math.random() * 1.0 - 0.5;
                        particle.vy = 0.8 * particle.vy + Math.random() * 1.0 - 0.5;
                        particle.image = ((particle.t & 3) == 2 ? steam : steam2)[frame / 2];
                        return;
                    }
                }
                particle.image = frame < 0 || frame >= 20 ? null : (frame < 9 ? hailstone[9 - frame] : hailstone[0]);
            }
        };
        TREASURE = new SimpleAnimationType(50){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[100];
                int i = 0;
                while (i < particles.length) {
                    double x = Math.random() * 22.0;
                    double y = Math.random() * 10.0;
                    particles[i++] = new Particle(-10.0 + x - 0.5 * y, -8.0 + y + 0.35 * x, (int)(Math.random() * 50.0), spark[0]);
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                int dt = particle.t - frame;
                particle.image = dt < 0 ? null : (dt < 9 ? spark[9 - dt] : spark[0]);
            }
        };
        SHIELD = new SimpleAnimationType(70, -5){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[200];
                int i = 0;
                while (i < particles.length) {
                    double cos;
                    double phi = (Math.random() - 0.5) * Math.PI;
                    double circ = Math.random();
                    if (circ > (cos = Math.cos(phi))) continue;
                    double y = 25.0 * Math.sin(phi);
                    double x = 25.0 * cos * Math.sin(circ * Math.PI * 2.0 / cos);
                    particles[i++] = new Particle(x, y, (int)(Math.random() * 40.0), darkGreen[0]);
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) <= 0 || frame >= 30) {
                    particle.image = null;
                    return;
                }
                double sin = particle.y / 25.0;
                double cos = Math.sqrt(1.0 - sin * sin);
                double dCirc = 2.0 * cos * Math.cos(Math.PI * particle.x / (50.0 * cos));
                particle.x += dCirc;
                if (frame <= 10) {
                    particle.image = darkGreen[10 - frame];
                } else if (frame >= 20) {
                    particle.image = darkGreen[frame - 20];
                }
            }
        };
        BURST = new SimpleAnimationType(60, -5){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[100];
                int i = 0;
                while (i < particles.length) {
                    double cos;
                    double phi = (Math.random() - 0.5) * Math.PI;
                    double circ = Math.random();
                    if (circ > (cos = Math.cos(phi))) continue;
                    double y = 20.0 * Math.sin(phi);
                    double x = 20.0 * cos * Math.sin(circ * Math.PI * 2.0 / cos);
                    particles[i++] = new Particle(x, y, (int)(Math.random() * 30.0), limeGreen[0]);
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) <= 0 || frame >= 30) {
                    particle.image = null;
                    return;
                }
                if (frame <= 10) {
                    particle.image = limeGreen[10 - frame];
                } else if (frame > 15) {
                    particle.vx = 0.05 * particle.x;
                    particle.vy = 0.05 * particle.y;
                    particle.image = limeGreen[frame <= 20 ? 0 : frame - 20];
                }
            }
        };
        SPARKS = new SimpleAnimationType(40){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[50];
                int i = 0;
                while (i < particles.length) {
                    double x = -20.0 + Math.random() * 40.0;
                    double y = 25.0 + Math.random() * 10.0;
                    particles[i++] = new Particle(x, y, (int)(Math.random() * 20.0), spark[0]);
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) <= 0 || frame >= 20) {
                    particle.image = null;
                    return;
                }
                particle.vx = 0.8 * particle.vx + 2.0 * Math.random() - 1.0;
                particle.vy = 0.8 * particle.vy - 3.0 * Math.random() + 1.0;
                particle.image = spark[frame <= 10 ? 0 : frame - 10];
            }
        };
        GOLD_SHOWER = new SimpleAnimationType(60){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[100];
                int i = 0;
                while (i < particles.length) {
                    double x = -25.0 + Math.random() * 50.0;
                    double y = -45.0 + Math.random() * 50.0;
                    particles[i++] = new Particle(x, y, (int)(Math.random() * 30.0), spark[0]);
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) <= 0 || frame >= 30) {
                    particle.image = null;
                    return;
                }
                particle.vx = 0.8 * particle.vx + 0.5 * Math.random() - 0.25;
                particle.vy = 0.8 * particle.vy + 0.2;
                if (frame <= 10) {
                    particle.image = spark[10 - frame];
                } else if (frame > 20) {
                    particle.image = spark[frame - 20];
                }
            }
        };
        SPLIT = new SimpleAnimationType(90){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[120];
                int i = 0;
                while (i < particles.length) {
                    double y = 4.0 + Math.random() * 62.0;
                    particles[i++] = new Particle(-1.0, y - 40.0, 10 * (i / 40) + (int)((70.0 - y) / 7.0), leftArc[0]);
                    particles[i++] = new Particle(1.0, y - 40.0, 10 * (i / 40) + (int)((70.0 - y) / 7.0), rightArc[0]);
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) <= 0 || frame >= 40) {
                    particle.image = null;
                    return;
                }
                if (particle.x < 0.0) {
                    if (frame <= 10) {
                        particle.image = leftArc[10 - frame];
                    } else if (frame > 30) {
                        particle.image = leftArc[frame - 30];
                    } else {
                        particle.vx -= 0.2 * Math.random();
                    }
                } else if (frame <= 10) {
                    particle.image = rightArc[10 - frame];
                } else if (frame > 30) {
                    particle.image = rightArc[frame - 30];
                } else {
                    particle.vx += 0.2 * Math.random();
                }
            }
        };
        SWIRL = new SimpleAnimationType(100){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[150];
                int i = 0;
                while (i < particles.length) {
                    double y = -6.0 + Math.random() * 32.0;
                    double x = -24.0 + Math.random() * 10.0;
                    int t = (int)(Math.random() * 5.0) * 10;
                    int p = 0;
                    while (p < 10) {
                        particles[i++] = new Particle(x, y, 0.0, -1.0, t++, pinkRightArc[0]);
                        ++p;
                        ++t;
                    }
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) <= 0) {
                    particle.image = null;
                    return;
                }
                int f = particle.t % 10;
                if (frame > 40 && (f += frame - 40) > 9) {
                    particle.image = null;
                    return;
                }
                if (particle.x > 20.0) {
                    particle.x = -20.0;
                }
                particle.vx = 2.0 * Math.cos(particle.x * Math.PI / 50.0);
                particle.image = pinkRightArc[f];
            }
        };
        SWARM = new SimpleAnimationType(70){

            @Override
            Particle[] createParticles(Animation animation) {
                Particle[] particles = new Particle[80];
                int i = 0;
                while (i < particles.length) {
                    double x = -25.0 + Math.random() * 50.0;
                    double y = -30.0 + Math.random() * 60.0;
                    particles[i++] = new Particle(x, y, (int)(Math.random() * 30.0), soot[0]);
                }
                return particles;
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) < 0) {
                    particle.image = null;
                    return;
                }
                particle.vx = 0.7 * particle.vx;
                particle.vy = 0.7 * particle.vy + 0.1;
                if (Math.random() < 0.1) {
                    particle.vx += 6.0 * Math.random() - 3.0 - particle.x / 20.0;
                    particle.vy += 6.0 * Math.random() - 5.0 - particle.y / 20.0;
                }
                if (frame <= 9) {
                    particle.image = soot[9 - frame];
                } else if (frame > 30) {
                    if (frame < 40) {
                        particle.image = soot[frame - 30];
                    } else if (frame == 40) {
                        particle.image = null;
                    }
                }
            }
        };
        LIGHTNING = new SimpleAnimationType(30){

            @Override
            Particle[] createParticles(Animation animation) {
                ArrayList<Particle> particles = new ArrayList<Particle>();
                particles.add(new Particle(0.0, -30.0, 9, purple[0]));
                int lineStart = 0;
                int y = -3;
                while (y > -207) {
                    int lastLineStart = lineStart;
                    lineStart = particles.size();
                    double branchProb = 0.2 / (double)(lineStart - lastLineStart);
                    int j = lastLineStart;
                    while (j < lineStart) {
                        Particle p = (Particle)particles.get(j);
                        int t = p.t - (int)(Math.random() * 1.4);
                        if (t >= 0) {
                            double vx;
                            if (Math.random() < branchProb) {
                                vx = Math.random() + 1.0;
                                particles.add(new Particle(p.x + vx, y, vx, 0.0, t, purple[0]));
                                vx = -Math.random() - 1.0;
                                particles.add(new Particle(p.x + vx, y, vx, 0.0, t, purple[0]));
                            } else {
                                vx = p.vx + Math.random() - 0.5;
                                particles.add(new Particle(p.x + vx, y, vx, 0.0, t, purple[0]));
                            }
                        }
                        p.vx = 0.0;
                        ++j;
                    }
                    y -= 3;
                }
                int j = lineStart;
                while (j < particles.size()) {
                    ((Particle)particles.get((int)j)).vx = 0.0;
                    ++j;
                }
                int i = 0;
                while (i < 30) {
                    double angle = Math.random() * Math.PI * 2.0;
                    double speed = 5.0 + Math.random() * 2.0;
                    particles.add(new Particle(0.0, 0.0, speed * Math.sin(angle), speed * Math.cos(angle), 10, white[0]));
                    ++i;
                }
                return particles.toArray(new Particle[particles.size()]);
            }

            @Override
            void update(Particle particle, int frame) {
                if ((frame -= particle.t) < 0) {
                    particle.image = null;
                } else if (particle.t == 10) {
                    particle.vx = 0.8 * particle.vx + 0.5 * Math.random() - 0.25;
                    particle.vy = 0.8 * particle.vy + 0.5 * Math.random() - 0.15;
                    particle.image = frame <= 10 ? white[0] : (frame > 19 ? null : white[frame - 10]);
                } else {
                    particle.image = frame < 10 ? purple[frame] : null;
                }
            }
        };
        int[] nArray = new int[16];
        nArray[1] = 1727529217;
        nArray[2] = 1071120898;
        nArray[4] = 1073676802;
        nArray[5] = -1711341568;
        nArray[6] = -1716781056;
        nArray[7] = 1726218497;
        nArray[8] = 1725104385;
        nArray[9] = -1715142656;
        nArray[10] = -1717436416;
        nArray[11] = 1724121345;
        nArray[13] = 1726218497;
        nArray[14] = 1722941697;
        nArray[15] = 1066074626;
        int[] pixels = nArray;
        blood = Animation.makeImages(pixels, 4, 4);
        int[] nArray2 = new int[100];
        nArray2[2] = 0x337F7F7F;
        nArray2[4] = 1283555713;
        nArray2[5] = 423114808;
        nArray2[6] = 431799484;
        nArray2[7] = 423114808;
        nArray2[8] = 0x337F7F7F;
        nArray2[10] = 0x19FFFFFF;
        nArray2[11] = 1288819153;
        nArray2[13] = 0x337F7F7F;
        nArray2[14] = 0x4CFFFFFF;
        nArray2[15] = 431799484;
        nArray2[16] = 0x33FFFFFF;
        nArray2[17] = 1283555713;
        nArray2[18] = 431799484;
        nArray2[19] = 0x19FFFFFF;
        nArray2[20] = 427128181;
        nArray2[22] = 0x4CFFFFFF;
        nArray2[23] = 1286187433;
        nArray2[24] = 423114808;
        nArray2[25] = 1284871573;
        nArray2[26] = 0x33484848;
        nArray2[27] = 0x33020202;
        nArray2[28] = 0x337F7F7F;
        nArray2[29] = 1288819153;
        nArray2[31] = 0x33D9D9D9;
        nArray2[32] = 1284871573;
        nArray2[33] = 0x337F7F7F;
        nArray2[34] = 0x33FFFFFF;
        nArray2[35] = 0x33B6B6B6;
        nArray2[36] = 0x33B6B6B6;
        nArray2[37] = 0x4C444444;
        nArray2[38] = 0x33D9D9D9;
        nArray2[39] = 427128181;
        nArray2[40] = 427128181;
        nArray2[41] = 1286187433;
        nArray2[43] = 427128181;
        nArray2[44] = 0x33B6B6B6;
        nArray2[45] = 1288819153;
        nArray2[46] = 419759365;
        nArray2[47] = 0x33B6B6B6;
        nArray2[48] = 0x33484848;
        nArray2[49] = 419759365;
        nArray2[50] = 0x19FFFFFF;
        nArray2[51] = 427128181;
        nArray2[52] = 0x4CFFFFFF;
        nArray2[53] = 0x33FFFFFF;
        nArray2[54] = 1283555713;
        nArray2[55] = 0x4CFFFFFF;
        nArray2[56] = 0x4C444444;
        nArray2[57] = 0x33D9D9D9;
        nArray2[58] = 1286187433;
        nArray2[59] = 0x33020202;
        nArray2[60] = 0x19FFFFFF;
        nArray2[61] = 427128181;
        nArray2[62] = 1286187433;
        nArray2[63] = 423114808;
        nArray2[64] = 0x33FFFFFF;
        nArray2[65] = 1284871573;
        nArray2[66] = 0x33D9D9D9;
        nArray2[67] = 423114808;
        nArray2[69] = 423114808;
        nArray2[72] = 0x33020202;
        nArray2[73] = 0x33FFFFFF;
        nArray2[74] = 0x33484848;
        nArray2[76] = 0x33B6B6B6;
        nArray2[77] = 1284871573;
        nArray2[78] = 0x4CFFFFFF;
        nArray2[79] = 1284871573;
        nArray2[80] = 1288819153;
        nArray2[83] = 0x4C444444;
        nArray2[84] = 431799484;
        nArray2[85] = 1283555713;
        nArray2[86] = 0x33484848;
        nArray2[87] = 0x33484848;
        nArray2[88] = 0x33020202;
        nArray2[89] = 0x19FFFFFF;
        nArray2[92] = 1284871573;
        nArray2[95] = 419759365;
        nArray2[97] = 1286187433;
        pixels = nArray2;
        smoke = Animation.makeImages(pixels, 10, 10);
        int[] nArray3 = new int[49];
        nArray3[2] = 871826175;
        nArray3[3] = 872352985;
        nArray3[4] = 872352985;
        nArray3[8] = 872350400;
        nArray3[9] = -2098459905;
        nArray3[10] = -2097214742;
        nArray3[11] = -2097214273;
        nArray3[12] = 872350400;
        nArray3[14] = 871826175;
        nArray3[15] = -2097214273;
        nArray3[16] = -906025777;
        nArray3[17] = -47920;
        nArray3[18] = -906027617;
        nArray3[19] = -2097214742;
        nArray3[20] = 872350400;
        nArray3[21] = 872352985;
        nArray3[22] = -2097214273;
        nArray3[23] = -57698;
        nArray3[24] = -41258;
        nArray3[25] = -57880;
        nArray3[26] = -2097214273;
        nArray3[27] = 872352985;
        nArray3[28] = 872350400;
        nArray3[29] = -2097214742;
        nArray3[30] = -906032448;
        nArray3[31] = -55614;
        nArray3[32] = -906031384;
        nArray3[33] = -2098459905;
        nArray3[34] = 871826175;
        nArray3[36] = 872350400;
        nArray3[37] = -2098459905;
        nArray3[38] = -2097214273;
        nArray3[39] = -2097214742;
        nArray3[40] = 872350400;
        nArray3[44] = 871826175;
        nArray3[45] = 872352985;
        nArray3[46] = 872350400;
        pixels = nArray3;
        lightning = Animation.makeImages(pixels, 7, 7);
        int[] nArray4 = new int[36];
        nArray4[0] = 0x23F3F3F;
        nArray4[1] = 872546818;
        nArray4[2] = -2046688766;
        nArray4[3] = 0x50010101;
        nArray4[4] = -2063465982;
        nArray4[5] = 0x32020202;
        nArray4[6] = 889324034;
        nArray4[7] = -1610481150;
        nArray4[8] = -1258291200;
        nArray4[9] = -754974720;
        nArray4[10] = -1526595070;
        nArray4[11] = 0x77010101;
        nArray4[12] = 319161862;
        nArray4[13] = -2046688766;
        nArray4[14] = -218103808;
        nArray4[15] = -33554432;
        nArray4[16] = -754974720;
        nArray4[17] = 1828782337;
        nArray4[18] = 1275134209;
        nArray4[19] = -1610481150;
        nArray4[20] = -536870912;
        nArray4[21] = -134217728;
        nArray4[22] = -1258291200;
        nArray4[23] = 1291911425;
        nArray4[24] = 0xF080808;
        nArray4[25] = -1761476094;
        nArray4[26] = -1342177280;
        nArray4[27] = -1576926718;
        nArray4[28] = -1996357118;
        nArray4[29] = 2097217793;
        nArray4[31] = 0xE090909;
        nArray4[32] = 0x32020202;
        nArray4[33] = 302450439;
        nArray4[34] = 822215170;
        nArray4[35] = 0x80F0F0F;
        pixels = nArray4;
        soot = Animation.makeImages(pixels, 6, 6);
        int[] nArray5 = new int[49];
        nArray5[2] = 872396345;
        nArray5[3] = 872397590;
        nArray5[4] = 872401415;
        nArray5[8] = 872398890;
        nArray5[9] = 2147483393;
        nArray5[10] = 2147475745;
        nArray5[11] = 2147474689;
        nArray5[12] = 872401415;
        nArray5[14] = 872397590;
        nArray5[15] = 2147475745;
        nArray5[16] = -855642610;
        nArray5[17] = -953;
        nArray5[18] = -856031470;
        nArray5[19] = 2147483393;
        nArray5[20] = 872397590;
        nArray5[21] = 872401415;
        nArray5[22] = 2147483393;
        nArray5[23] = -393454;
        nArray5[24] = -65671;
        nArray5[25] = -2276;
        nArray5[26] = 2147475745;
        nArray5[27] = 872401415;
        nArray5[28] = 872398890;
        nArray5[29] = 2147474689;
        nArray5[30] = -855643337;
        nArray5[31] = -4806;
        nArray5[32] = -855644667;
        nArray5[33] = 2147474689;
        nArray5[34] = 872396345;
        nArray5[36] = 872401415;
        nArray5[37] = 2147483393;
        nArray5[38] = 2147475745;
        nArray5[39] = 2147483393;
        nArray5[40] = 872401415;
        nArray5[44] = 872396345;
        nArray5[45] = 872397590;
        nArray5[46] = 872401415;
        pixels = nArray5;
        spark = Animation.makeImages(pixels, 7, 7);
        int[] nArray6 = new int[16];
        nArray6[1] = 2138439427;
        nArray6[2] = 2137259793;
        nArray6[4] = 2132934411;
        nArray6[5] = -16711903;
        nArray6[6] = -443220223;
        nArray6[7] = 2134638343;
        nArray6[8] = 2136080153;
        nArray6[9] = -866451712;
        nArray6[10] = -10551552;
        nArray6[11] = 2133589767;
        nArray6[13] = 2141454105;
        nArray6[14] = 2138701575;
        pixels = nArray6;
        green = Animation.makeImages(pixels, 4, 4);
        int[] nArray7 = new int[25];
        nArray7[1] = 1275181579;
        nArray7[2] = 1275181579;
        nArray7[3] = 1275174667;
        nArray7[5] = 1275181579;
        nArray7[6] = -1308379635;
        nArray7[7] = -452746485;
        nArray7[8] = -1308385782;
        nArray7[9] = 1275174667;
        nArray7[10] = 1275181579;
        nArray7[11] = -452746485;
        nArray7[12] = -16477173;
        nArray7[13] = -452820471;
        nArray7[14] = 1275165192;
        nArray7[15] = 1275174667;
        nArray7[16] = -1308385782;
        nArray7[17] = -452820471;
        nArray7[18] = -1308395767;
        nArray7[19] = 1275165192;
        nArray7[21] = 1275174667;
        nArray7[22] = 1275165192;
        nArray7[23] = 1275165192;
        pixels = nArray7;
        darkGreen = Animation.makeImages(pixels, 5, 5);
        int[] nArray8 = new int[25];
        nArray8[1] = 1282473729;
        nArray8[2] = 1282473729;
        nArray8[3] = 1279393537;
        nArray8[5] = 1282473729;
        nArray8[6] = -1299448064;
        nArray8[7] = -445645048;
        nArray8[8] = -1302266112;
        nArray8[9] = 1279393537;
        nArray8[10] = 1282473729;
        nArray8[11] = -445645048;
        nArray8[12] = -9896185;
        nArray8[13] = -447873278;
        nArray8[14] = 1275657992;
        nArray8[15] = 1279393537;
        nArray8[16] = -1302266112;
        nArray8[17] = -447873278;
        nArray8[18] = -1304232192;
        nArray8[19] = 1275657992;
        nArray8[21] = 1279393537;
        nArray8[22] = 1275657992;
        nArray8[23] = 1275657992;
        pixels = nArray8;
        limeGreen = Animation.makeImages(pixels, 5, 5);
        int[] nArray9 = new int[25];
        nArray9[1] = 1291843318;
        nArray9[2] = 1291843318;
        nArray9[3] = 1291843318;
        nArray9[5] = 1291843318;
        nArray9[6] = -1291848203;
        nArray9[7] = -436210187;
        nArray9[8] = -1291848203;
        nArray9[9] = 1291843318;
        nArray9[10] = 1291843318;
        nArray9[11] = -436210187;
        nArray9[12] = -2571;
        nArray9[13] = -436210187;
        nArray9[14] = 1291843318;
        nArray9[15] = 1291843318;
        nArray9[16] = -1291848203;
        nArray9[17] = -436210187;
        nArray9[18] = -1291848203;
        nArray9[19] = 1291843318;
        nArray9[21] = 1291843318;
        nArray9[22] = 1291843318;
        nArray9[23] = 1291843318;
        pixels = nArray9;
        white = Animation.makeImages(pixels, 5, 5);
        int[] nArray10 = new int[49];
        nArray10[2] = 864618495;
        nArray10[3] = 864618495;
        nArray10[4] = 861995775;
        nArray10[8] = 864618495;
        nArray10[9] = 2140342271;
        nArray10[10] = 2140342271;
        nArray10[11] = 2137850367;
        nArray10[12] = 861995775;
        nArray10[14] = 864618495;
        nArray10[15] = 2140342271;
        nArray10[16] = -1298920961;
        nArray10[17] = -445840897;
        nArray10[18] = -865205249;
        nArray10[19] = 2137850367;
        nArray10[20] = 861995775;
        nArray10[21] = 864618495;
        nArray10[22] = 2140342271;
        nArray10[23] = -445840897;
        nArray10[24] = -9762561;
        nArray10[25] = -445840897;
        nArray10[26] = 2136540671;
        nArray10[27] = 860357375;
        nArray10[28] = 861995775;
        nArray10[29] = 2137850367;
        nArray10[30] = -865205249;
        nArray10[31] = -445840897;
        nArray10[32] = -1302593281;
        nArray10[33] = 2136540671;
        nArray10[34] = 860357375;
        nArray10[36] = 861995775;
        nArray10[37] = 2137850367;
        nArray10[38] = 2136540671;
        nArray10[39] = 2136540671;
        nArray10[40] = 860357375;
        nArray10[44] = 861995775;
        nArray10[45] = 860357375;
        nArray10[46] = 860357375;
        pixels = nArray10;
        purple = Animation.makeImages(pixels, 7, 7);
        int[] nArray11 = new int[48];
        nArray11[0] = -1308560897;
        nArray11[1] = -16583937;
        nArray11[2] = -16583937;
        nArray11[3] = -1308560897;
        nArray11[6] = 1711535103;
        nArray11[7] = -1727859969;
        nArray11[8] = -872156161;
        nArray11[9] = -16583937;
        nArray11[10] = -1308560897;
        nArray11[12] = 855828722;
        nArray11[13] = 1711532531;
        nArray11[14] = -1727862542;
        nArray11[15] = -872159760;
        nArray11[16] = -16589593;
        nArray11[17] = -1308560897;
        nArray11[19] = 855826152;
        nArray11[20] = 1711528676;
        nArray11[21] = -1727866397;
        nArray11[22] = -872163873;
        nArray11[23] = -16589593;
        nArray11[25] = 855826152;
        nArray11[26] = 1711528676;
        nArray11[27] = -1727866397;
        nArray11[28] = -872163873;
        nArray11[29] = -16594991;
        nArray11[30] = 855823582;
        nArray11[31] = 1711526106;
        nArray11[32] = -1727870766;
        nArray11[33] = -872166443;
        nArray11[34] = -16594991;
        nArray11[35] = -1308569379;
        nArray11[36] = 1711523022;
        nArray11[37] = -1727874107;
        nArray11[38] = -872170298;
        nArray11[39] = -16599104;
        nArray11[40] = -1308573494;
        nArray11[42] = -1308576324;
        nArray11[43] = -16599104;
        nArray11[44] = -16599104;
        nArray11[45] = -1308576064;
        pixels = nArray11;
        rightArc = Animation.makeImages(pixels, 6, 8);
        int[] nArray12 = new int[48];
        nArray12[2] = -1308560897;
        nArray12[3] = -16583937;
        nArray12[4] = -16583937;
        nArray12[5] = -1308560897;
        nArray12[7] = -1308560897;
        nArray12[8] = -16583937;
        nArray12[9] = -872156161;
        nArray12[10] = -1727859969;
        nArray12[11] = 1711535103;
        nArray12[12] = -1308560897;
        nArray12[13] = -16589593;
        nArray12[14] = -872159760;
        nArray12[15] = -1727862542;
        nArray12[16] = 1711532531;
        nArray12[17] = 855828722;
        nArray12[18] = -16589593;
        nArray12[19] = -872163873;
        nArray12[20] = -1727866397;
        nArray12[21] = 1711528676;
        nArray12[22] = 855826152;
        nArray12[24] = -16594991;
        nArray12[25] = -872163873;
        nArray12[26] = -1727866397;
        nArray12[27] = 1711528676;
        nArray12[28] = 855826152;
        nArray12[30] = -1308569379;
        nArray12[31] = -16594991;
        nArray12[32] = -872166443;
        nArray12[33] = -1727870766;
        nArray12[34] = 1711526106;
        nArray12[35] = 855823582;
        nArray12[37] = -1308573494;
        nArray12[38] = -16599104;
        nArray12[39] = -872170298;
        nArray12[40] = -1727874107;
        nArray12[41] = 1711523022;
        nArray12[44] = -1308576064;
        nArray12[45] = -16599104;
        nArray12[46] = -16599104;
        nArray12[47] = -1308576324;
        pixels = nArray12;
        leftArc = Animation.makeImages(pixels, 6, 8);
        int[] nArray13 = new int[48];
        nArray13[0] = -1292828417;
        nArray13[1] = -916737;
        nArray13[2] = -916737;
        nArray13[3] = -1292828417;
        nArray13[6] = 1727202303;
        nArray13[7] = -1712192769;
        nArray13[8] = -856488961;
        nArray13[9] = -916737;
        nArray13[10] = -1292828417;
        nArray13[12] = 870843122;
        nArray13[13] = 1726546931;
        nArray13[14] = -1712848142;
        nArray13[15] = -857406480;
        nArray13[16] = -2358553;
        nArray13[17] = -1292828417;
        nArray13[19] = 870187752;
        nArray13[20] = 1725563876;
        nArray13[21] = -1713831197;
        nArray13[22] = -858455073;
        nArray13[23] = -2358553;
        nArray13[25] = 870187752;
        nArray13[26] = 1725563876;
        nArray13[27] = -1713831197;
        nArray13[28] = -858455073;
        nArray13[29] = -3734831;
        nArray13[30] = 869532382;
        nArray13[31] = 1724908506;
        nArray13[32] = -1714945326;
        nArray13[33] = -859110443;
        nArray13[34] = -3734831;
        nArray13[35] = -1294991139;
        nArray13[36] = 1724122062;
        nArray13[37] = -1715797307;
        nArray13[38] = -860093498;
        nArray13[39] = -4783424;
        nArray13[40] = -1296039734;
        nArray13[42] = -1296760644;
        nArray13[43] = -4783424;
        nArray13[44] = -4783424;
        nArray13[45] = -1296695104;
        pixels = nArray13;
        pinkRightArc = Animation.makeImages(pixels, 6, 8);
        int[] nArray14 = new int[64];
        nArray14[2] = 2147481075;
        nArray14[3] = -855640589;
        nArray14[4] = -855640589;
        nArray14[5] = 2147481075;
        nArray14[9] = 2147481075;
        nArray14[10] = -855640589;
        nArray14[11] = -2574;
        nArray14[12] = -2574;
        nArray14[13] = -860562689;
        nArray14[14] = 2142624255;
        nArray14[16] = 2147481075;
        nArray14[17] = -855640589;
        nArray14[18] = -2574;
        nArray14[19] = -3014670;
        nArray14[20] = -3014670;
        nArray14[21] = -4859393;
        nArray14[22] = -860562689;
        nArray14[23] = 2142615551;
        nArray14[24] = -855640589;
        nArray14[25] = -2574;
        nArray14[26] = -3014670;
        nArray14[27] = -5177345;
        nArray14[28] = -4462849;
        nArray14[29] = -5650433;
        nArray14[30] = -4868353;
        nArray14[31] = -860571649;
        nArray14[32] = -855640589;
        nArray14[33] = -2574;
        nArray14[34] = -3014670;
        nArray14[35] = -4462849;
        nArray14[36] = -5645057;
        nArray14[37] = -5650433;
        nArray14[38] = -4868353;
        nArray14[39] = -860571649;
        nArray14[40] = 2147481075;
        nArray14[41] = -860562689;
        nArray14[42] = -4859393;
        nArray14[43] = -5650433;
        nArray14[44] = -5650433;
        nArray14[45] = -4868353;
        nArray14[46] = -860571649;
        nArray14[47] = 2142615551;
        nArray14[49] = 2142624255;
        nArray14[50] = -860562689;
        nArray14[51] = -4868353;
        nArray14[52] = -4868353;
        nArray14[53] = -860571649;
        nArray14[54] = 2142615551;
        nArray14[58] = 2142615551;
        nArray14[59] = -860571649;
        nArray14[60] = -860571649;
        nArray14[61] = 2142615551;
        pixels = nArray14;
        hailstone = Animation.makeImages(pixels, 8, 8);
        int[] nArray15 = new int[144];
        nArray15[3] = 0x32FFFFFF;
        nArray15[4] = 0x32FFFFFF;
        nArray15[5] = 0x32FFFFFF;
        nArray15[6] = 0x32FFFFFF;
        nArray15[7] = 0x32FFFFFF;
        nArray15[14] = 0x32FFFFFF;
        nArray15[15] = 0x65FFFFFF;
        nArray15[16] = Integer.MAX_VALUE;
        nArray15[17] = Integer.MAX_VALUE;
        nArray15[18] = 0x65FFFFFF;
        nArray15[19] = 0x4CFFFFFF;
        nArray15[20] = 0x32FFFFFF;
        nArray15[25] = 0x32FFFFFF;
        nArray15[26] = 0x65FFFFFF;
        nArray15[27] = -1728053249;
        nArray15[28] = -855638017;
        nArray15[29] = -1728053249;
        nArray15[30] = -1728053249;
        nArray15[31] = 0x65FFFFFF;
        nArray15[32] = 0x4CFFFFFF;
        nArray15[33] = 0x32FFFFFF;
        nArray15[36] = 0x32FFFFFF;
        nArray15[37] = 0x65FFFFFF;
        nArray15[38] = Integer.MAX_VALUE;
        nArray15[39] = -1291845633;
        nArray15[40] = -855638017;
        nArray15[41] = -1291845633;
        nArray15[42] = -855638017;
        nArray15[43] = Integer.MAX_VALUE;
        nArray15[44] = 0x65FFFFFF;
        nArray15[45] = 0x65FFFFFF;
        nArray15[46] = 0x32FFFFFF;
        nArray15[48] = 0x32FFFFFF;
        nArray15[49] = 0x65FFFFFF;
        nArray15[50] = Integer.MAX_VALUE;
        nArray15[51] = -1728053249;
        nArray15[52] = -855638017;
        nArray15[53] = -855638017;
        nArray15[54] = -1291845633;
        nArray15[55] = -1728053249;
        nArray15[56] = -1728053249;
        nArray15[57] = Integer.MAX_VALUE;
        nArray15[58] = 0x65FFFFFF;
        nArray15[59] = 0x32FFFFFF;
        nArray15[61] = 0x32FFFFFF;
        nArray15[62] = 0x65FFFFFF;
        nArray15[63] = Integer.MAX_VALUE;
        nArray15[64] = -855638017;
        nArray15[65] = -1291845633;
        nArray15[66] = -1291845633;
        nArray15[67] = -855638017;
        nArray15[68] = -1291845633;
        nArray15[69] = -1728053249;
        nArray15[70] = Integer.MAX_VALUE;
        nArray15[71] = 0x32FFFFFF;
        nArray15[73] = 0x32FFFFFF;
        nArray15[74] = 0x65FFFFFF;
        nArray15[75] = Integer.MAX_VALUE;
        nArray15[76] = -1728053249;
        nArray15[77] = Integer.MAX_VALUE;
        nArray15[78] = -1728053249;
        nArray15[79] = -855638017;
        nArray15[80] = -855638017;
        nArray15[81] = -1291845633;
        nArray15[82] = -1728053249;
        nArray15[83] = 0x32FFFFFF;
        nArray15[84] = 0x32FFFFFF;
        nArray15[85] = Integer.MAX_VALUE;
        nArray15[86] = -1291845633;
        nArray15[87] = -855638017;
        nArray15[88] = -1728053249;
        nArray15[89] = 0x65FFFFFF;
        nArray15[90] = Integer.MAX_VALUE;
        nArray15[91] = -1728053249;
        nArray15[92] = -1291845633;
        nArray15[93] = -1728053249;
        nArray15[94] = Integer.MAX_VALUE;
        nArray15[95] = 0x32FFFFFF;
        nArray15[96] = 0x32FFFFFF;
        nArray15[97] = Integer.MAX_VALUE;
        nArray15[98] = -1291845633;
        nArray15[99] = -1728053249;
        nArray15[100] = Integer.MAX_VALUE;
        nArray15[101] = 0x4CFFFFFF;
        nArray15[102] = 0x65FFFFFF;
        nArray15[103] = Integer.MAX_VALUE;
        nArray15[104] = -1728053249;
        nArray15[105] = Integer.MAX_VALUE;
        nArray15[106] = 0x65FFFFFF;
        nArray15[107] = 0x32FFFFFF;
        nArray15[108] = 0x32FFFFFF;
        nArray15[109] = 0x65FFFFFF;
        nArray15[110] = Integer.MAX_VALUE;
        nArray15[111] = Integer.MAX_VALUE;
        nArray15[112] = 0x65FFFFFF;
        nArray15[113] = 0x32FFFFFF;
        nArray15[114] = 0x4CFFFFFF;
        nArray15[115] = 0x65FFFFFF;
        nArray15[116] = 0x65FFFFFF;
        nArray15[117] = 0x65FFFFFF;
        nArray15[118] = 0x32FFFFFF;
        nArray15[121] = 0x32FFFFFF;
        nArray15[122] = 0x65FFFFFF;
        nArray15[123] = 0x65FFFFFF;
        nArray15[124] = 0x4CFFFFFF;
        nArray15[125] = 0x32FFFFFF;
        nArray15[126] = 0x32FFFFFF;
        nArray15[127] = 0x4CFFFFFF;
        nArray15[128] = 0x4CFFFFFF;
        nArray15[129] = 0x32FFFFFF;
        nArray15[134] = 0x32FFFFFF;
        nArray15[135] = 0x32FFFFFF;
        nArray15[136] = 0x32FFFFFF;
        nArray15[139] = 0x32FFFFFF;
        nArray15[140] = 0x32FFFFFF;
        pixels = nArray15;
        steam = Animation.makeImages(pixels, 12, 12);
        int[] nArray16 = new int[144];
        nArray16[0] = 0x32FFFFFF;
        nArray16[1] = 0x32FFFFFF;
        nArray16[5] = 0x32FFFFFF;
        nArray16[6] = 0x32FFFFFF;
        nArray16[7] = 0x32FFFFFF;
        nArray16[8] = 0x32FFFFFF;
        nArray16[12] = 0x32FFFFFF;
        nArray16[15] = 0x32FFFFFF;
        nArray16[16] = 0x32FFFFFF;
        nArray16[17] = 0x65FFFFFF;
        nArray16[18] = Integer.MAX_VALUE;
        nArray16[19] = Integer.MAX_VALUE;
        nArray16[20] = 0x65FFFFFF;
        nArray16[21] = 0x32FFFFFF;
        nArray16[25] = 0x32FFFFFF;
        nArray16[26] = 0x32FFFFFF;
        nArray16[27] = 0x4CFFFFFF;
        nArray16[28] = 0x65FFFFFF;
        nArray16[29] = Integer.MAX_VALUE;
        nArray16[30] = -1728053249;
        nArray16[31] = -1728053249;
        nArray16[32] = Integer.MAX_VALUE;
        nArray16[33] = 0x65FFFFFF;
        nArray16[34] = 0x32FFFFFF;
        nArray16[37] = 0x32FFFFFF;
        nArray16[38] = 0x4CFFFFFF;
        nArray16[39] = 0x65FFFFFF;
        nArray16[40] = Integer.MAX_VALUE;
        nArray16[41] = -1728053249;
        nArray16[42] = -1291845633;
        nArray16[43] = -1291845633;
        nArray16[44] = -1728053249;
        nArray16[45] = Integer.MAX_VALUE;
        nArray16[46] = 0x65FFFFFF;
        nArray16[47] = 0x32FFFFFF;
        nArray16[48] = 0x32FFFFFF;
        nArray16[49] = 0x65FFFFFF;
        nArray16[50] = Integer.MAX_VALUE;
        nArray16[51] = Integer.MAX_VALUE;
        nArray16[52] = -1291845633;
        nArray16[53] = -1291845633;
        nArray16[54] = -855638017;
        nArray16[55] = -855638017;
        nArray16[56] = -1291845633;
        nArray16[57] = Integer.MAX_VALUE;
        nArray16[58] = 0x65FFFFFF;
        nArray16[59] = 0x32FFFFFF;
        nArray16[60] = 0x32FFFFFF;
        nArray16[61] = Integer.MAX_VALUE;
        nArray16[62] = -1728053249;
        nArray16[63] = -1291845633;
        nArray16[64] = -1728053249;
        nArray16[65] = -1728053249;
        nArray16[66] = -1728053249;
        nArray16[67] = -1291845633;
        nArray16[68] = -1728053249;
        nArray16[69] = 0x65FFFFFF;
        nArray16[70] = 0x32FFFFFF;
        nArray16[72] = 0x32FFFFFF;
        nArray16[73] = Integer.MAX_VALUE;
        nArray16[74] = -1291845633;
        nArray16[75] = -855638017;
        nArray16[76] = Integer.MAX_VALUE;
        nArray16[77] = Integer.MAX_VALUE;
        nArray16[78] = Integer.MAX_VALUE;
        nArray16[79] = -1291845633;
        nArray16[80] = -855638017;
        nArray16[81] = -1728053249;
        nArray16[82] = 0x65FFFFFF;
        nArray16[83] = 0x32FFFFFF;
        nArray16[84] = 0x32FFFFFF;
        nArray16[85] = 0x65FFFFFF;
        nArray16[86] = Integer.MAX_VALUE;
        nArray16[87] = Integer.MAX_VALUE;
        nArray16[88] = 0x65FFFFFF;
        nArray16[89] = 0x65FFFFFF;
        nArray16[90] = -1728053249;
        nArray16[91] = -1728053249;
        nArray16[92] = -1291845633;
        nArray16[93] = -1291845633;
        nArray16[94] = Integer.MAX_VALUE;
        nArray16[95] = 0x32FFFFFF;
        nArray16[96] = 0x32FFFFFF;
        nArray16[97] = 0x32FFFFFF;
        nArray16[98] = 0x32FFFFFF;
        nArray16[99] = 0x4CFFFFFF;
        nArray16[100] = 0x65FFFFFF;
        nArray16[101] = 0x65FFFFFF;
        nArray16[102] = Integer.MAX_VALUE;
        nArray16[103] = -1291845633;
        nArray16[104] = -855638017;
        nArray16[105] = -855638017;
        nArray16[106] = -1728053249;
        nArray16[107] = 0x32FFFFFF;
        nArray16[109] = 0x32FFFFFF;
        nArray16[111] = 0x32FFFFFF;
        nArray16[112] = 0x4CFFFFFF;
        nArray16[113] = 0x65FFFFFF;
        nArray16[114] = Integer.MAX_VALUE;
        nArray16[115] = -1291845633;
        nArray16[116] = -855638017;
        nArray16[117] = -1291845633;
        nArray16[118] = Integer.MAX_VALUE;
        nArray16[119] = 0x32FFFFFF;
        nArray16[120] = 0x32FFFFFF;
        nArray16[121] = 0x32FFFFFF;
        nArray16[124] = 0x32FFFFFF;
        nArray16[125] = 0x4CFFFFFF;
        nArray16[126] = 0x65FFFFFF;
        nArray16[127] = Integer.MAX_VALUE;
        nArray16[128] = -1728053249;
        nArray16[129] = -1728053249;
        nArray16[130] = 0x65FFFFFF;
        nArray16[131] = 0x32FFFFFF;
        nArray16[134] = 0x32FFFFFF;
        nArray16[137] = 0x32FFFFFF;
        nArray16[138] = 0x32FFFFFF;
        nArray16[139] = 0x32FFFFFF;
        nArray16[140] = 0x32FFFFFF;
        nArray16[141] = 0x32FFFFFF;
        nArray16[142] = 0x32FFFFFF;
        pixels = nArray16;
        steam2 = Animation.makeImages(pixels, 12, 12);
        int[] nArray17 = new int[132];
        nArray17[4] = 0x7121212;
        nArray17[5] = 308042844;
        nArray17[14] = 0x2FFBFBF;
        nArray17[15] = 0x555B5552;
        nArray17[16] = -884457409;
        nArray17[17] = -431669443;
        nArray17[18] = -1405076163;
        nArray17[19] = 625952840;
        nArray17[26] = -1956752564;
        nArray17[27] = -11251892;
        nArray17[28] = -9937060;
        nArray17[29] = -10134696;
        nArray17[30] = -11450815;
        nArray17[31] = -648589495;
        nArray17[32] = 659245886;
        nArray17[36] = 0x2BFBFBF;
        nArray17[37] = 1834635340;
        nArray17[38] = -10791855;
        nArray17[39] = -9345181;
        nArray17[40] = -8555669;
        nArray17[41] = -8292752;
        nArray17[42] = -11451586;
        nArray17[43] = -11450560;
        nArray17[44] = -499831252;
        nArray17[45] = 1294543138;
        nArray17[48] = 456998205;
        nArray17[49] = -194814888;
        nArray17[50] = -9410204;
        nArray17[51] = -9344925;
        nArray17[52] = -8161168;
        nArray17[53] = -9806248;
        nArray17[54] = -11713987;
        nArray17[55] = -12633803;
        nArray17[56] = -13817303;
        nArray17[57] = -81386719;
        nArray17[58] = 841359649;
        nArray17[60] = 506930717;
        nArray17[61] = -193696667;
        nArray17[62] = -8226444;
        nArray17[63] = -9016476;
        nArray17[64] = -10267057;
        nArray17[65] = -11581630;
        nArray17[66] = -12305094;
        nArray17[67] = -13489110;
        nArray17[68] = -13554646;
        nArray17[69] = -14804199;
        nArray17[70] = -2061691372;
        nArray17[72] = 508049207;
        nArray17[73] = -177643686;
        nArray17[74] = -10201005;
        nArray17[75] = -10528942;
        nArray17[76] = -10726579;
        nArray17[77] = -11450300;
        nArray17[78] = -12370886;
        nArray17[79] = -12896972;
        nArray17[80] = -13423059;
        nArray17[81] = -14606562;
        nArray17[82] = -937090784;
        nArray17[83] = 0x45F5F5F;
        nArray17[84] = 0xA3F3F3F;
        nArray17[85] = -649445060;
        nArray17[86] = -10199463;
        nArray17[87] = -10528684;
        nArray17[88] = -12305351;
        nArray17[89] = -12304579;
        nArray17[90] = -13225425;
        nArray17[91] = -13686230;
        nArray17[92] = -14343390;
        nArray17[93] = -14737891;
        nArray17[94] = -417325540;
        nArray17[95] = 0xE1B1B1B;
        nArray17[97] = 1597978935;
        nArray17[98] = -61715640;
        nArray17[99] = -13094867;
        nArray17[100] = -14080476;
        nArray17[101] = -13817303;
        nArray17[102] = -13817560;
        nArray17[103] = -14541282;
        nArray17[104] = -14672355;
        nArray17[105] = -14738148;
        nArray17[106] = -1927801324;
        nArray17[110] = 891560996;
        nArray17[111] = 1797069081;
        nArray17[112] = -887218916;
        nArray17[113] = -316794343;
        nArray17[114] = -266726124;
        nArray17[115] = -618849252;
        nArray17[116] = -1525081834;
        nArray17[117] = 1562122778;
        nArray17[118] = 0xB220B0B;
        nArray17[124] = 0x41F1F1F;
        nArray17[125] = 387649552;
        nArray17[126] = 0x1B171717;
        nArray17[127] = 0xB0B0B0B;
        pixels = nArray17;
        asteroid = Animation.makeImages(pixels, 12, 11);
        int[] nArray18 = new int[100];
        nArray18[3] = 855612162;
        nArray18[4] = 872369425;
        nArray18[5] = 855601666;
        nArray18[6] = 872398870;
        nArray18[12] = 872369425;
        nArray18[13] = 1711249411;
        nArray18[14] = 1711249411;
        nArray18[15] = 1711240961;
        nArray18[16] = 1711240961;
        nArray18[17] = 855601666;
        nArray18[21] = 855612162;
        nArray18[22] = 1711249411;
        nArray18[23] = 2147457797;
        nArray18[24] = -1291872250;
        nArray18[25] = -1291881472;
        nArray18[26] = 2147460873;
        nArray18[27] = 1728001288;
        nArray18[28] = 855601666;
        nArray18[30] = 855612162;
        nArray18[31] = 1728035344;
        nArray18[32] = 2147466517;
        nArray18[33] = -1291872250;
        nArray18[34] = -436233722;
        nArray18[35] = -436226026;
        nArray18[36] = -1291867126;
        nArray18[37] = 2147448065;
        nArray18[38] = 1728001288;
        nArray18[39] = 872398870;
        nArray18[40] = 855612162;
        nArray18[41] = 1711249411;
        nArray18[42] = -1291863024;
        nArray18[43] = -436233722;
        nArray18[44] = -9713;
        nArray18[45] = -35328;
        nArray18[46] = -436243200;
        nArray18[47] = -1291863024;
        nArray18[48] = 1711240961;
        nArray18[49] = 855601666;
        nArray18[50] = 872369425;
        nArray18[51] = 1711240961;
        nArray18[52] = -1291881472;
        nArray18[53] = -436247534;
        nArray18[54] = -35328;
        nArray18[55] = -39415;
        nArray18[56] = -436247534;
        nArray18[57] = -1291885047;
        nArray18[58] = 1728035344;
        nArray18[59] = 855599111;
        nArray18[60] = 855601666;
        nArray18[61] = 1728035344;
        nArray18[62] = 2147433747;
        nArray18[63] = -1291891703;
        nArray18[64] = -436243200;
        nArray18[65] = -436226026;
        nArray18[66] = -1291896048;
        nArray18[67] = 2147433747;
        nArray18[68] = 1711236616;
        nArray18[69] = 855599111;
        nArray18[71] = 855601666;
        nArray18[72] = 1711240961;
        nArray18[73] = 2147448065;
        nArray18[74] = -1291889142;
        nArray18[75] = -1291885047;
        nArray18[76] = 2147443975;
        nArray18[77] = 1728001288;
        nArray18[78] = 872369425;
        nArray18[82] = 855601666;
        nArray18[83] = 1728035344;
        nArray18[84] = 1728035344;
        nArray18[85] = 1711236616;
        nArray18[86] = 1728001288;
        nArray18[87] = 855599111;
        nArray18[93] = 872398870;
        nArray18[94] = 855601666;
        nArray18[95] = 872369425;
        nArray18[96] = 855599111;
        pixels = nArray18;
        explosion = Animation.makeImages(pixels, 10, 10);
    }

    public static void setDefaultLabelColor(Color color) {
        defaultLabelColor = color;
    }

    public static void setAttachedByDefault(boolean attached) {
        defaultAttached = attached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelAll() {
        List list = animations;
        synchronized (list) {
            Iterator iter = animations.iterator();
            while (iter.hasNext()) {
                ((Animation)iter.next()).cancel();
            }
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    private static Image[] makeImages(int[] pixels, int width, int height) {
        Image[] images = new Image[10];
        images[0] = new BufferedImage(width, height, 2);
        ((BufferedImage)images[0]).setRGB(0, 0, width, height, pixels, 0, width);
        int i = 1;
        while (i < 10) {
            int p = 0;
            while (p < pixels.length) {
                int alpha = ((pixels[p] & 0xFF000000) >>> 4) * 7 << 1 & 0xFF000000;
                pixels[p] = pixels[p] & 0xFFFFFF | alpha;
                ++p;
            }
            images[i] = new BufferedImage(width, height, 2);
            ((BufferedImage)images[i]).setRGB(0, 0, width, height, pixels, 0, width);
            ++i;
        }
        return images;
    }

    boolean step() {
        return !this.cancelled && this.type.step(this.particles, this.frame, this) | this.checkLabels(this.frame++);
    }

    private boolean isSpecial(double x, double y) {
        Location screenLoc = new Location(x + (double)this.getMyLocation().getX(), y + (double)this.getMyLocation().getY());
        int i = 0;
        while (i < this.specialRegions.size()) {
            DrawableInterface region = (DrawableInterface)this.specialRegions.get(i);
            if (region.contains(screenLoc)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void start() {
        this.particles = this.type.createParticles(this);
        this.frame = 0;
        this.step();
        if (!animations.contains(this)) {
            animations.add(this);
        }
        if (this.getCanvas() == null) {
            this.addToCanvas(this.oldCanvas);
        }
        if (!timer.isRunning()) {
            timer.start(0.02, 0.02);
        }
    }

    public Animation fireOne(DrawableInterface object) {
        return this.type.fireOne(this, object);
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void addSpecialRegion(DrawableInterface object) {
        this.specialRegions.add(object);
    }

    public void label(DrawableInterface object, String label) {
        this.label(object, label, 0);
    }

    public void label(DrawableInterface object, String label, int dt) {
        int i;
        while ((i = label.indexOf(10)) != -1) {
            this.labels.add(new Label(label.substring(0, i), object, dt));
            dt += LABEL_FONT.getSize();
            label = label.substring(i + 1);
        }
        this.labels.add(new Label(label, object, dt));
    }

    public void setAttached(boolean attached) {
        this.attached = attached;
        if (this.attached) {
            this.update();
        }
    }

    @Override
    public void update() {
        Location basisLocation;
        super.update();
        if (!this.attached) {
            return;
        }
        Location myLocation = this.getMyLocation();
        if (!myLocation.equals(basisLocation = this.basis.getMyLocation())) {
            myLocation.translate(basisLocation.getX() - myLocation.getX() + this.dx, basisLocation.getY() - myLocation.getY() + this.dy);
        }
    }

    public Animation(AnimationType type, DrawableInterface object) {
        this(null, type, object);
    }

    private Animation(Particle[] particles, AnimationType type, DrawableInterface object) {
        super(type.getLocation(object), false, null, object.getCanvas());
        this.type = type;
        if (object == null) {
            throw new IllegalArgumentException("Object to decorate cannot be null.");
        }
        this.oldCanvas = object.getCanvas();
        this.basis = (ObjectDrawShape)object;
        Location basisLoc = this.basis.getMyLocation();
        Location myLoc = this.getMyLocation();
        this.dx = myLoc.getX() - basisLoc.getX();
        this.dy = myLoc.getY() - basisLoc.getY();
        basisLoc.depend(this);
        this.particles = particles;
        this.setColor(defaultLabelColor);
        this.ready();
    }

    private boolean checkLabels(int frame) {
        int earliestFrame = frame - 40;
        int i = 0;
        while (i < this.labels.size()) {
            if (((Label)this.labels.get((int)i)).t >= earliestFrame) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Location getCenter(DrawableInterface object) {
        Rectangle2D bounds = ((ObjectDrawShape)object).getShape().getBounds2D();
        return new Location(bounds.getCenterX(), bounds.getCenterY());
    }

    private static Location getOrigin(DrawableInterface object) {
        return new Location(((ObjectDrawShape)object).getMyLocation());
    }

    private void renderLabels(Graphics2D g, int frame) {
        g.setFont(LABEL_FONT);
        if (this.firstLabelRender) {
            this.firstLabelRender = false;
            FontMetrics fm = g.getFontMetrics();
            int i = 0;
            while (i < this.labels.size()) {
                Label label = (Label)this.labels.get(i);
                label.offset = -fm.stringWidth(label.text) / 2;
                ++i;
            }
        }
        int i = 0;
        while (i < this.labels.size()) {
            Label label = (Label)this.labels.get(i);
            int dt = frame - label.t;
            if (dt >= 0 && dt < 40) {
                g.setColor(this.labelColors[dt > 30 ? dt - 30 : 0]);
                Location origin = Animation.getCenter(label.object);
                int x = origin.getX() + label.offset;
                int y = origin.getY() - dt;
                g.drawString(label.text, x, y);
            }
            ++i;
        }
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        if (this.attached) {
            this.basis.moveTo(point.getDoubleX() - (double)this.dx, point.getDoubleY() - (double)this.dy);
        } else {
            super.moveTo(point);
        }
    }

    @Override
    public void moveTo(double x, double y) {
        if (this.attached) {
            this.basis.moveTo(x - (double)this.dx, y - (double)this.dy);
        } else {
            super.moveTo(x, y);
        }
    }

    @Override
    public void move(double dx, double dy) {
        if (this.attached) {
            this.basis.move(dx, dy);
        } else {
            super.move(dx, dy);
        }
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
        int RGB = c.getRGB() & 0xFFFFFF;
        int alpha = c.getAlpha();
        this.labelColors[0] = c;
        int i = 0;
        while (i < 10) {
            this.labelColors[i] = new Color(RGB | alpha * (10 - i) / 10 << 24, true);
            ++i;
        }
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        return false;
    }

    @Override
    public String toString() {
        return "new Animation()";
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.frame == 0) {
            return;
        }
        AffineTransform saveAT = g.getTransform();
        g.translate(this.getMyLocation().getX(), this.getMyLocation().getY());
        this.type.draw(this.particles, g, this);
        g.setTransform(saveAT);
        this.renderLabels(g, this.frame);
    }

    @Override
    public Shape makeShape() {
        return new GeneralPath();
    }

    public int getX() {
        return this.getMyLocation().getX();
    }

    public int getY() {
        return this.getMyLocation().getY();
    }

    public double getDoubleX() {
        return this.getMyLocation().getDoubleX();
    }

    public double getDoubleY() {
        return this.getMyLocation().getDoubleY();
    }

    public Location getLocation() {
        return this.getMyLocation();
    }

    static class AnimationRunner {
        AnimationRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void step() {
            HashSet<DrawingCanvas> canvases = new HashSet<DrawingCanvas>();
            List list = animations;
            synchronized (list) {
                Iterator iter = animations.iterator();
                while (iter.hasNext()) {
                    Animation animation = (Animation)iter.next();
                    if (!animation.step()) {
                        iter.remove();
                        animation.removeFromCanvas();
                        continue;
                    }
                    canvases.add(animation.getCanvas());
                }
                if (animations.isEmpty()) {
                    timer.stop();
                }
            }
            for (DrawingCanvas canvas : canvases) {
                if (canvas == null) continue;
                canvas.update();
            }
        }
    }

    private static abstract class AnimationType {
        private AnimationType() {
        }

        Animation fireOne(Animation animation, DrawableInterface object) {
            return null;
        }

        private void accum(int[] pixels, int[] accum, int offset) {
            if (offset < 0) {
                int source = 0;
                int dest = -offset;
                while (dest < pixels.length) {
                    int n = dest++;
                    accum[n] = accum[n] + (pixels[source++] >>> 24);
                }
            } else {
                int source = offset;
                int dest = 0;
                while (source < pixels.length) {
                    int n = dest++;
                    accum[n] = accum[n] + (pixels[source++] >>> 24);
                }
            }
        }

        private BufferedImage getImage(VisibleImage image) {
            Image im = image.getImage();
            return im instanceof BufferedImage ? (BufferedImage)im : VisibleImage.createBufferedCopy(im);
        }

        Particle[] outline(ObjectDrawShape basis, double separation, Image image) {
            ArrayList<Particle> particles = new ArrayList<Particle>();
            if (basis instanceof VisibleImage) {
                int b;
                int a;
                BufferedImage target = this.getImage((VisibleImage)basis);
                int w = target.getWidth(null);
                int h = target.getHeight(null);
                int[] pixels = new int[w * h];
                int[] accum = new int[w * h];
                target.getRGB(0, 0, w, h, pixels, 0, w);
                this.accum(pixels, accum, 0);
                this.accum(pixels, accum, 1);
                this.accum(pixels, accum, w);
                this.accum(pixels, accum, w + 1);
                double prob = 0.5 / separation;
                int y = 1;
                while (y < h - 1) {
                    int x = 1;
                    while (x < w - 1) {
                        int i = x + w * y;
                        int a2 = accum[i];
                        if (a2 >= 20 && a2 <= 1000 && Math.random() < prob) {
                            double gx = 0.7 * (double)(-accum[i - w - 1] - accum[i + w - 1] + accum[i - w + 1] + accum[i + w + 1]) - (double)accum[i - 1] + (double)accum[i + 1];
                            double gy = 0.7 * (double)(-accum[i - w - 1] + accum[i + w - 1] - accum[i - w + 1] + accum[i + w + 1]) - (double)accum[i - w] + (double)accum[i + w];
                            double g = -1.0 / Math.sqrt(gx * gx + gy * gy);
                            particles.add(new Particle(x, y, g * gx, g * gy, 0, image));
                        }
                        ++x;
                    }
                    ++y;
                }
                y = 0;
                while (y < h) {
                    a = accum[y * w];
                    if (a >= 20 && a <= 1000 && Math.random() < prob) {
                        particles.add(new Particle(0.0, y, -1.0, 0.0, 0, image));
                    }
                    if ((b = accum[y * w + w - 1]) >= 20 && b <= 1000 && Math.random() < prob) {
                        particles.add(new Particle(w - 1, y, 1.0, 0.0, 0, image));
                    }
                    ++y;
                }
                int x = 0;
                while (x < w) {
                    a = accum[x];
                    if (a >= 20 && a <= 1000 && Math.random() < prob) {
                        particles.add(new Particle(x, 0.0, 0.0, -1.0, 0, image));
                    }
                    if ((b = accum[(h - 1) * w + x]) >= 20 && b <= 1000 && Math.random() < prob) {
                        particles.add(new Particle(x, h - 1, 0.0, 1.0, 0, image));
                    }
                    ++x;
                }
            } else {
                Location origin = Animation.getOrigin(basis);
                double dx = -origin.getDoubleX();
                double dy = -origin.getDoubleY();
                PathMeasurer.Point[] points = PathMeasurer.getPoints(basis.getShape(), separation);
                int i = 0;
                while (i < points.length) {
                    PathMeasurer.Point p = points[i];
                    particles.add(new Particle(p.x + dx, p.y + dy, p.nx, p.ny, 0, image));
                    ++i;
                }
            }
            return particles.toArray(new Particle[particles.size()]);
        }

        void draw(Graphics2D g, Particle particle) {
            if (particle != null && particle.image != null) {
                g.drawImage(particle.image, (int)(particle.x - particle.dx + 0.5), (int)(particle.y - particle.dy + 0.5), null);
            }
        }

        abstract void draw(Particle[] var1, Graphics2D var2, Animation var3);

        abstract Location getLocation(DrawableInterface var1);

        abstract Particle[] createParticles(Animation var1);

        abstract boolean step(Particle[] var1, int var2, Animation var3);
    }

    private static class BloodAnimationType
    extends SimpleAnimationType {
        private int dir;

        private BloodAnimationType(int dir) {
            super(40);
            this.dir = dir;
        }

        @Override
        Particle[] createParticles(Animation animation) {
            Particle[] particles = new Particle[50];
            double slope = 0.5 * Math.cos(Math.random() * Math.PI);
            double intercept = 20.0 * (1.0 - slope + Math.random()) - 30.0;
            double offset = Math.random() * 8.0 + 1.0 - 25.0;
            int frame = 0;
            while (frame < 10) {
                int i = 0;
                while (i < 5) {
                    double x = 20.0 + (double)this.dir * (Math.random() * 4.0 + (double)(4 * frame) - 20.0);
                    double y = x * slope + intercept + Math.random() * 3.0 - 1.5;
                    particles[frame * 5 + i] = new Particle(x + offset, y, frame, blood[0]);
                    ++i;
                }
                ++frame;
            }
            return particles;
        }

        @Override
        void update(Particle particle, int frame) {
            if (particle.y >= 30.0) {
                particle.image = null;
                return;
            }
            int dt = frame - particle.t;
            if (dt < 0) {
                particle.image = null;
            } else if (dt <= 9) {
                particle.image = blood[9 - dt];
            } else {
                particle.vy += 0.4 * Math.random();
            }
        }
    }

    private static class Label {
        private final String text;
        private final int t;
        private final DrawableInterface object;
        private int offset;

        public Label(String text, DrawableInterface object, int t) {
            this.text = text;
            this.t = t;
            this.object = object;
        }
    }

    private static class MeteorAnimationType
    extends SimpleAnimationType {
        public MeteorAnimationType() {
            super(0);
        }

        @Override
        Animation fireOne(Animation animation, DrawableInterface object) {
            int c = animation.getCount();
            animation.setCount(--c);
            Particle[] p = new Particle[11];
            System.arraycopy(animation.particles, 11 * c, p, 0, 11);
            Animation anim = new Animation(p, METEOR, animation.basis);
            anim.addSpecialRegion(object);
            return anim;
        }

        @Override
        Particle[] createParticles(Animation animation) {
            Particle[] particles = new Particle[11 * animation.count];
            int p = 0;
            int i = 0;
            while (p < animation.count) {
                double angle = Math.random() * Math.PI * 2.0;
                double r = Math.random() * 40.0;
                double speed = Math.sqrt(16.0 - 0.01 * r * r);
                double direction = Math.random() * Math.PI * 2.0;
                particles[i++] = new Particle(r * Math.sin(angle), r * Math.cos(angle), speed * Math.sin(direction), speed * Math.cos(direction), (int)(Math.random() * 4.0), asteroid[0]);
                int c = 0;
                while (c < 10) {
                    particles[i++] = new Particle(0.0, 0.0, c, explosion[0]);
                    ++c;
                }
                ++p;
            }
            return particles;
        }

        @Override
        boolean step(Particle[] particles, int frame, Animation animation) {
            int drawLength = 11 * animation.getCount();
            if (drawLength <= 0) {
                return false;
            }
            int i = 0;
            while (i < drawLength) {
                Particle particle = particles[i];
                if (particle != null) {
                    particle.vx += -0.01 * particle.x;
                    particle.vy += -0.01 * particle.y;
                    double d = particle.vx * particle.x + particle.vy * particle.y;
                    particle = particles[i + 10];
                    int c = 9;
                    while (c >= 0) {
                        Particle prev = particles[i + c];
                        particle.x = prev.x;
                        particle.y = prev.y;
                        particle.t = prev.t;
                        particle = prev;
                        --c;
                    }
                    particle.x += particle.vx;
                    particle.y += particle.vy;
                    if ((particle.t & 1) == 1 != d > 0.0) {
                        particle.t = particle.t + 1 & 3;
                    }
                }
                i += 11;
            }
            i = 0;
            while (i < particles.length) {
                int c = 1;
                while (c <= 10) {
                    Particle particle = particles[i + c];
                    int t = c - 1;
                    particle.image = frame < 10 ? ((t += 10 - frame) < 10 ? explosion[t] : null) : explosion[t];
                    ++c;
                }
                particles[i].image = asteroid[frame < 9 ? 9 - frame : 0];
                i += 11;
            }
            return true;
        }

        @Override
        public void draw(Particle[] particles, Graphics2D g, Animation animation) {
            int drawLength = 11 * animation.getCount();
            int i = 0;
            while (i < drawLength) {
                Particle particle = particles[i];
                if (particle.t < 2) {
                    this.draw(g, particle);
                }
                ++i;
            }
            int dx = animation.getMyLocation().getX();
            int dy = animation.getMyLocation().getY();
            g.translate(-dx, -dy);
            animation.basis.draw(g);
            g.translate(dx, dy);
            int i2 = 0;
            while (i2 < drawLength) {
                Particle particle = particles[i2];
                if (particle.t >= 2) {
                    this.draw(g, particle);
                }
                ++i2;
            }
        }

        @Override
        void update(Particle particle, int frame) {
        }
    }

    private static class Particle {
        private double x;
        private double y;
        private double vx;
        private double vy;
        private int t;
        private double dx;
        private double dy;
        private Image image;

        public Particle(double x, double y, int t, Image image) {
            this.x = x;
            this.y = y;
            this.t = t;
            this.setImage(image);
        }

        public Particle(double x, double y, double vx, double vy, int t, Image image) {
            this.x = x;
            this.y = y;
            this.vx = vx;
            this.vy = vy;
            this.t = t;
            this.setImage(image);
        }

        public void setImage(Image image) {
            if (image == null) {
                this.dy = 0.0;
                this.dx = 0.0;
            } else {
                this.dx = 0.5 * (double)image.getWidth(null);
                this.dy = 0.5 * (double)image.getHeight(null);
            }
            this.image = image;
        }
    }

    private static abstract class SimpleAnimationType
    extends AnimationType {
        private final int yOffset;
        private final int length;

        public SimpleAnimationType(int length) {
            this(length, 0);
        }

        public SimpleAnimationType(int length, int yOffset) {
            this.length = length;
            this.yOffset = yOffset;
        }

        @Override
        Location getLocation(DrawableInterface object) {
            Location loc = Animation.getCenter(object);
            loc.translate(0.0, this.yOffset);
            return loc;
        }

        @Override
        public void draw(Particle[] particles, Graphics2D g, Animation animation) {
            if (animation.frame >= this.length) {
                return;
            }
            int i = 0;
            while (i < particles.length) {
                this.draw(g, particles[i]);
                ++i;
            }
        }

        @Override
        abstract Particle[] createParticles(Animation var1);

        abstract void update(Particle var1, int var2);

        @Override
        boolean step(Particle[] particles, int frame, Animation animation) {
            int i = 0;
            while (i < particles.length) {
                Particle particle = particles[i];
                this.update(particle, frame);
                if (particle.image != null) {
                    particle.x += particle.vx;
                    particle.y += particle.vy;
                }
                ++i;
            }
            return frame < this.length;
        }
    }

    private static class SingleMeteorAnimationType
    extends SimpleAnimationType {
        public SingleMeteorAnimationType() {
            super(40);
        }

        @Override
        Particle[] createParticles(Animation animation) {
            Particle[] particles = new Particle[100];
            if (animation.specialRegions.isEmpty()) {
                throw new IllegalStateException("You must use addSpecialRegion() to specify a meteor's target.");
            }
            Location target = Animation.getCenter((DrawableInterface)animation.specialRegions.get(0));
            double tx = target.getX() - animation.getMyLocation().getX();
            double ty = target.getY() - animation.getMyLocation().getY();
            Particle accelerateParticle = particles[0] = new Particle(tx, ty, 1, null);
            if (animation.particles != null) {
                System.arraycopy(animation.particles, 0, particles, 1, 11);
            } else {
                double t = Math.sqrt(tx * tx + ty * ty);
                double ox = -20.0 * tx / t + Math.random() * 40.0 - 20.0;
                double oy = -20.0 * ty / t + Math.random() * 40.0 - 20.0;
                double o = Math.sqrt(ox * ox + oy * oy);
                double ovx = -3.0 * ox / o;
                double ovy = -3.0 * oy / o;
                Particle prev = particles[1] = new Particle(ox, oy, ovx, ovy, 0, asteroid[0]);
                int i = 2;
                while (i <= 11) {
                    prev = particles[i] = new Particle(prev.x - ovx, prev.y - ovy, 0, explosion[i - 2]);
                    ++i;
                }
            }
            Particle head = particles[1];
            double vAvgX = (tx - head.x) / 20.0;
            double vAvgY = (ty - head.y) / 20.0;
            accelerateParticle.vx = (vAvgX - head.vx) / 10.0;
            accelerateParticle.vy = (vAvgY - head.vy) / 10.0;
            return particles;
        }

        @Override
        boolean step(Particle[] particles, int frame, Animation animation) {
            if (frame < 20) {
                int i = 11;
                while (i > 1) {
                    Particle p = particles[i--];
                    p.x = particles[i].x;
                    p.y = particles[i].y;
                }
                Particle head = particles[1];
                head.x += (head.vx += particles[0].vx);
                head.y += (head.vy += particles[0].vy);
            } else {
                if (frame >= 40) {
                    return false;
                }
                if (frame == 20) {
                    double px = particles[0].x;
                    double py = particles[0].y;
                    int i = 0;
                    while (i < particles.length) {
                        double angle = Math.random() * Math.PI * 2.0;
                        double speed = Math.random() * 2.0 + 5.0;
                        particles[i] = new Particle(px, py, speed * Math.sin(angle), speed * Math.cos(angle), 0, explosion[0]);
                        ++i;
                    }
                }
                Image image = explosion[frame <= 30 ? 0 : frame - 30];
                int i = 0;
                while (i < particles.length) {
                    Particle p = particles[i];
                    p.vx = p.vx * 0.9 + 0.5 * Math.random() - 0.25;
                    p.x += p.vx;
                    p.vy = p.vy * 0.9 + 0.5 * Math.random() - 0.25;
                    p.y += p.vy;
                    p.image = image;
                    ++i;
                }
            }
            return true;
        }

        @Override
        void update(Particle particle, int frame) {
        }
    }
}

