/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.ClientListener;
import coffeedraw.Network;
import coffeedraw.NetworkThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import javax.swing.SwingUtilities;

public class Client
extends NetworkThread {
    private final InetSocketAddress serverAddress;
    private final ClientListener listener;
    private int channelID = -1;
    private String serverName = null;

    Client(String name, InetAddress server) throws IOException {
        super(name);
        this.serverAddress = new InetSocketAddress(server, Network.gamePort);
        this.listener = Network.clientListener;
        this.start();
    }

    public void sendMessage(String message) {
        this.enqueueMessage(message, this.channelID);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public String getServerName() {
        return this.serverName;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public boolean isRunning() {
        return super.isRunning();
    }

    @Override
    public void shutDown() {
        super.shutDown();
    }

    @Override
    void messageReceived(int channel, String channelName, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Client.this.listener.messageReceived(Client.this, message);
            }
        });
    }

    @Override
    void channelClosed(int channel, String channelName) {
        if (channel == this.channelID) {
            this.channelID = -1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Client.this.listener.clientDisconnected(Client.this);
                }
            });
        }
        this.shutDown();
    }

    @Override
    void channelReady(int channel, String channelName) {
        this.channelID = channel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Client.this.listener.clientConnected(Client.this);
            }
        });
    }

    @Override
    boolean setup() {
        if (!super.setup()) {
            return false;
        }
        try {
            SocketChannel channel = SocketChannel.open();
            channel.configureBlocking(false);
            channel.connect(this.serverAddress);
            channel.register(this.selector, 8, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.closeAll();
            return false;
        }
        return true;
    }

    @Override
    void tearDown() {
        Network.closeClient(this);
        super.tearDown();
    }
}

