/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Client;
import coffeedraw.ClientListener;
import coffeedraw.DrawableInterface;
import coffeedraw.FilledRect;
import coffeedraw.Location;
import coffeedraw.LocationPacket;
import coffeedraw.Network;
import coffeedraw.Packet;
import coffeedraw.Server;
import coffeedraw.ServerListener;
import coffeedraw.WindowController;
import java.awt.Color;
import java.util.WeakHashMap;

public class CoffeeTester
extends WindowController
implements ClientListener {
    private static final long serialVersionUID = 7579274715942148859L;
    private Client client;
    private WeakHashMap<Integer, DrawableInterface> clients = new WeakHashMap();

    public static void main(String[] args) {
        new CoffeeTester().startController(800, 600);
    }

    @Override
    public void begin() {
        Network.configure("CoffeeTester", new ServerListener(){

            @Override
            public void serverStarted(Server server) {
                new FilledRect(0.0, 0.0, 10.0, 10.0, Color.GREEN, CoffeeTester.this.canvas);
            }

            @Override
            public void channelOpened(Server server, int channelID, String channelName) {
                server.sendMessage(Packet.serialize(new LocationPacket(new Location(150.0, 150.0))));
            }

            @Override
            public void messageReceived(Server server, int channelID, String channelName, String message) {
            }

            @Override
            public void channelClosed(Server server, int channelID, String channelName) {
            }

            @Override
            public void serverStopped(Server server) {
            }
        }, this);
        Network.startServer("CoffeeTester");
    }

    @Override
    public void clientConnected(Client client) {
        this.client = client;
    }

    @Override
    public void messageReceived(Client client, String message) {
        Packet packet = Packet.deserialize(message);
        if (packet instanceof LocationPacket) {
            LocationPacket locPacket = (LocationPacket)packet;
            this.clients.get(locPacket.getID()).moveTo(locPacket.getLocation());
        }
    }

    @Override
    public void clientDisconnected(Client client) {
        this.client = null;
    }

    public void onSpacePress() {
        LocationPacket packet = new LocationPacket(new Location(Math.random() * 10.0, Math.random() * 10.0));
        String message = Packet.serialize(packet);
        this.client.sendMessage(message);
    }
}

