/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Dependent;
import coffeedraw.DrawableIterator;
import coffeedraw.FilledOval;
import coffeedraw.FilledPolygon;
import coffeedraw.FilledRect;
import coffeedraw.FramedOval;
import coffeedraw.FramedPolygon;
import coffeedraw.FramedRect;
import coffeedraw.Location;
import coffeedraw.ObjectDrawRectangularShape;
import coffeedraw.ObjectDrawShape;
import coffeedraw.ObjectType;
import coffeedraw.Polygon;
import coffeedraw.Resizable2DInterface;
import coffeedraw.Rounded;
import coffeedraw.SpawnPacket;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;

public interface DrawingCanvas
extends Dependent {
    public static final /* synthetic */ int[] $SWITCH_TABLE$coffeedraw$ObjectType;

    public Graphics getGraphics();

    public boolean prepareImage(Image var1, ImageObserver var2);

    public Image createImage(int var1, int var2);

    public boolean requestFocusInWindow();

    public void requestFocus();

    public Rectangle getBounds();

    public void clear();

    public void repaint();

    public void disableAutoRepaint();

    public void enableAutoRepaint();

    public Dimension getSize();

    public int getWidth();

    public int getHeight();

    public void addMouseListener(MouseListener var1);

    public void addMouseMotionListener(MouseMotionListener var1);

    public void addComponentListener(ComponentListener var1);

    public void addKeyListener(KeyListener var1);

    public DrawableIterator getDrawableIterator();

    public Color getBackground();

    public void setBackground(Color var1);

    public void setLoupe(Location var1, double var2, double var4);

    public void setLoupe(Location var1);

    public void clearLoupe();

    public static SpawnPacket fromObject(Resizable2DInterface object) {
        SpawnPacket packet = new SpawnPacket();
        Location loc = new Location(object.getLocation().getDoubleX(), object.getLocation().getDoubleY());
        packet.setLocation(loc);
        packet.setWidth(object.getDoubleWidth());
        packet.setHeight(object.getDoubleHeight());
        packet.setRotation(object.getRotation());
        packet.setColor(object.getColor());
        if (object.getClass().getName().contains("Framed")) {
            packet.setFilled(false);
        } else {
            packet.setFilled(true);
        }
        if (object instanceof ObjectDrawRectangularShape) {
            packet.setType(ObjectType.RECT);
            if (object instanceof Rounded) {
                Rounded obj = (Rounded)((Object)object);
                packet.setArcWidth(obj.getDoubleArcWidth());
                packet.setArcHeight(obj.getDoubleArcHeight());
            }
        } else if (object instanceof Polygon) {
            packet.setType(ObjectType.POLY);
            Polygon poly = (Polygon)((Object)object);
            packet.setNumSides(poly.getNumSides());
        } else if (object instanceof ObjectDrawShape) {
            packet.setType(ObjectType.OVAL);
        }
        return packet;
    }

    public static Resizable2DInterface getObject(SpawnPacket packet, DrawingCanvas canvas) throws Exception {
        ObjectType type = packet.getType();
        ObjectDrawShape object = null;
        switch (type) {
            case TEXT: {
                object = null;
                throw new Exception("Text object serialization is not implemented yet.");
            }
            case RECT: {
                if (packet.isFilled()) {
                    object = new FilledRect(packet.getLocation(), packet.getWidth(), packet.getHeight(), packet.getRotation(), packet.getColor(), canvas);
                    break;
                }
                object = new FramedRect(packet.getLocation(), packet.getWidth(), packet.getHeight(), packet.getRotation(), packet.getColor(), canvas);
                break;
            }
            case OVAL: {
                if (packet.isFilled()) {
                    object = new FilledOval(packet.getLocation(), packet.getWidth(), packet.getHeight(), packet.getRotation(), packet.getColor(), canvas);
                    break;
                }
                object = new FramedOval(packet.getLocation(), packet.getWidth(), packet.getHeight(), packet.getRotation(), packet.getColor(), canvas);
                break;
            }
            case POLY: {
                if (packet.isFilled()) {
                    object = new FilledPolygon(packet.getNumSides(), packet.getLocation(), packet.getWidth(), packet.getHeight(), packet.getRotation(), packet.getColor(), canvas);
                    break;
                }
                object = new FramedPolygon(packet.getNumSides(), packet.getLocation(), packet.getWidth(), packet.getHeight(), packet.getRotation(), packet.getColor(), canvas);
                break;
            }
            default: {
                object = new FilledRect(packet.getLocation(), packet.getWidth(), packet.getHeight(), packet.getRotation(), packet.getColor(), canvas);
            }
        }
        return object;
    }
}

