/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Timer;

public class EventTimer {
    public static final Object SELF = new Object();
    private static final Set activeTimers = Collections.synchronizedSet(new HashSet());
    private Timer timer;
    private Object[] args;
    private Object target;
    private Method method;
    private long lastFireTime = -1L;
    private long startTime = -1L;
    private long initialFireTime = -1L;
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EventTimer.this.fire();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopAll() {
        Set set = activeTimers;
        synchronized (set) {
            Iterator iter = activeTimers.iterator();
            while (iter.hasNext()) {
                ((EventTimer)iter.next()).timer.stop();
            }
            activeTimers.clear();
        }
    }

    public EventTimer(Object target, String methodName, Object[] args) {
        this.setTarget(target, methodName, args);
    }

    public void setTarget(Object target, String methodName, Object[] args) {
        Class[] types = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            if (args[i] == SELF) {
                args[i] = this;
            }
            types[i] = args[i] == null ? null : args[i].getClass();
            ++i;
        }
        if (target == null) {
            throw new IllegalArgumentException("Timer target cannot be null.");
        }
        try {
            Class<?> targetClass = target instanceof Class ? (Class<?>)target : target.getClass();
            Method[] methods = targetClass.getMethods();
            int i2 = 0;
            while (i2 < methods.length) {
                if (EventTimer.matches(methods[i2], methodName, types)) {
                    this.method = methods[i2];
                    this.target = target;
                    this.args = args;
                    this.timer = new Timer(1000, this.listener);
                    EventTimer.checkTypes(args, this.method);
                    break;
                }
                ++i2;
            }
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("The security manager does not permit access to the methods of this target.");
        }
        if (this.method == null) {
            StringBuffer error = new StringBuffer();
            error.append("Unable to locate method: public void ");
            error.append(methodName);
            error.append("(");
            int i3 = 0;
            while (i3 < types.length) {
                if (i3 != 0) {
                    error.append(", ");
                }
                error.append(EventTimer.simpleClassName(types[i3]));
                ++i3;
            }
            error.append(")");
            throw new IllegalArgumentException(error.toString());
        }
    }

    private static boolean matches(Method method, String methodName, Class[] types) {
        if (!method.getName().equals(methodName)) {
            return false;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length != types.length) {
            return false;
        }
        int i = 0;
        while (i < params.length) {
            if (!EventTimer.typeMatch(types[i], params[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean typeMatch(Class valueClass, Class paramClass) {
        if (valueClass == null) {
            return !paramClass.isPrimitive();
        }
        if (paramClass.isPrimitive()) {
            if (paramClass == Boolean.TYPE) {
                return valueClass == Boolean.class;
            }
            if (paramClass == Character.TYPE) {
                return valueClass == Character.class;
            }
            return Number.class.isAssignableFrom(valueClass);
        }
        return paramClass.isAssignableFrom(valueClass);
    }

    private static void checkTypes(Object[] values, Method method) {
        Class<?>[] params = method.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            if (params[i].isPrimitive() && params[i] != Boolean.TYPE && params[i] != Character.TYPE) {
                Number n = (Number)values[i];
                if (params[i] == Byte.TYPE) {
                    if (!(values[i] instanceof Byte)) {
                        values[i] = new Byte(n.byteValue());
                    }
                } else if (params[i] == Short.TYPE) {
                    if (!(values[i] instanceof Short)) {
                        values[i] = new Short(n.shortValue());
                    }
                } else if (params[i] == Integer.TYPE) {
                    if (!(values[i] instanceof Integer)) {
                        values[i] = new Integer(n.intValue());
                    }
                } else if (params[i] == Long.TYPE) {
                    if (!(values[i] instanceof Long)) {
                        values[i] = new Long(n.longValue());
                    }
                } else if (params[i] == Float.TYPE) {
                    if (!(values[i] instanceof Float)) {
                        values[i] = new Float(n.floatValue());
                    }
                } else if (params[i] == Double.TYPE && !(values[i] instanceof Double)) {
                    values[i] = new Double(n.doubleValue());
                }
            }
            ++i;
        }
    }

    private static String simpleClassName(Class c) {
        String s = c.getName();
        return s.substring(s.lastIndexOf(".") + 1);
    }

    public EventTimer(Object target, String methodName) {
        this.setTarget(target, methodName, new Object[0]);
    }

    public void setTarget(Object target, String methodName) {
        this.setTarget(target, methodName, new Object[0]);
    }

    public EventTimer(Object target, String methodName, Object arg1) {
        this.setTarget(target, methodName, new Object[]{arg1});
    }

    public void setTarget(Object target, String methodName, Object arg1) {
        this.setTarget(target, methodName, new Object[]{arg1});
    }

    public EventTimer(Object target, String methodName, Object arg1, Object arg2) {
        this.setTarget(target, methodName, new Object[]{arg1, arg2});
    }

    public void setTarget(Object target, String methodName, Object arg1, Object arg2) {
        this.setTarget(target, methodName, new Object[]{arg1, arg2});
    }

    public EventTimer(Object target, String methodName, Object arg1, Object arg2, Object arg3) {
        this.setTarget(target, methodName, new Object[]{arg1, arg2, arg3});
    }

    public void setTarget(Object target, String methodName, Object arg1, Object arg2, Object arg3) {
        this.setTarget(target, methodName, new Object[]{arg1, arg2, arg3});
    }

    public void setDelay(double startDelay, double delay) {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.internalSetDelay(this.lastFireTime < 0L ? delay : delay - 0.001 * (double)(System.currentTimeMillis() - this.lastFireTime), delay);
            this.timer.start();
            this.timer.setInitialDelay((int)(startDelay * 1000.0 + 0.5));
        } else {
            this.internalSetDelay(startDelay, delay);
        }
    }

    private void internalSetDelay(double startDelay, double delay) {
        if (delay > 0.0) {
            this.timer.setRepeats(true);
            this.timer.setDelay((int)(delay * 1000.0 + 0.5));
        } else {
            this.timer.setRepeats(false);
        }
        if (startDelay < 0.0) {
            startDelay = 0.0;
        }
        this.timer.setInitialDelay((int)(startDelay * 1000.0 + 0.5));
    }

    public void start() {
        this.timer.stop();
        this.internalStart();
    }

    private void internalStart() {
        this.timer.start();
        activeTimers.add(this);
        this.startTime = System.currentTimeMillis();
        this.initialFireTime = -1L;
        this.lastFireTime = -1L;
    }

    public void start(double startDelay, double delay) {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.internalSetDelay(startDelay, delay);
        this.internalStart();
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    public void stop() {
        activeTimers.remove(this);
        this.timer.stop();
    }

    public double getStartDelay() {
        return 0.001 * (double)this.timer.getInitialDelay();
    }

    public double getDelay() {
        return this.timer.isRepeats() ? 0.001 * (double)this.timer.getDelay() : 0.0;
    }

    public double getTimeSinceStart() {
        return this.startTime < 0L ? 0.0 : 0.001 * (double)(System.currentTimeMillis() - this.startTime);
    }

    public double getTimeSinceInitialFiring() {
        return this.initialFireTime < 0L ? 0.0 : 0.001 * (double)(System.currentTimeMillis() - this.initialFireTime);
    }

    public double getTimeSincePreviousFiring() {
        return this.lastFireTime < 0L ? 0.0 : 0.001 * (double)(System.currentTimeMillis() - this.lastFireTime);
    }

    public boolean isInitialFiring() {
        return this.initialFireTime < 0L;
    }

    /*
     * Loose catch block
     */
    public void fire() {
        try {
            try {
                if (this.method != null) {
                    this.method.invoke(this.target, this.args);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.lastFireTime = System.currentTimeMillis();
                if (this.initialFireTime < 0L) {
                    this.initialFireTime = this.lastFireTime;
                }
                if (!this.timer.isRepeats()) {
                    activeTimers.remove(this);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                this.lastFireTime = System.currentTimeMillis();
                if (this.initialFireTime < 0L) {
                    this.initialFireTime = this.lastFireTime;
                }
                if (!this.timer.isRepeats()) {
                    activeTimers.remove(this);
                }
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                this.lastFireTime = System.currentTimeMillis();
                if (this.initialFireTime < 0L) {
                    this.initialFireTime = this.lastFireTime;
                }
                if (!this.timer.isRepeats()) {
                    activeTimers.remove(this);
                }
            }
        }
        finally {
            this.lastFireTime = System.currentTimeMillis();
            if (this.initialFireTime < 0L) {
                this.initialFireTime = this.lastFireTime;
            }
            if (!this.timer.isRepeats()) {
                activeTimers.remove(this);
            }
        }
    }
}

