/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawRectangularShape;
import coffeedraw.Text;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.io.Serializable;

public class FilledArc
extends ObjectDrawRectangularShape
implements Serializable {
    private double startAngle;
    private double arcAngle;

    public FilledArc(double x, double y, double width, double height, double startAngle, double arcAngle, Color color, DrawingCanvas canvas) {
        super(x, y, width, height, true, color, canvas);
        this.startAngle = startAngle;
        this.arcAngle = arcAngle;
        this.ready();
    }

    public FilledArc(double x, double y, double width, double height, double startAngle, double arcAngle, DrawingCanvas canvas) {
        this(x, y, width, height, startAngle, arcAngle, null, canvas);
    }

    public FilledArc(Location point, double width, double height, double startAngle, double arcAngle, Color color, DrawingCanvas canvas) {
        this(point.getDoubleX(), point.getDoubleY(), width, height, startAngle, arcAngle, color, canvas);
    }

    public FilledArc(Location point, double width, double height, double startAngle, double arcAngle, DrawingCanvas canvas) {
        this(point, width, height, startAngle, arcAngle, null, canvas);
    }

    public FilledArc(Location corner1, Location corner2, double startAngle, double arcAngle, Color color, DrawingCanvas canvas) {
        this(corner1, corner2.getDoubleX() - corner1.getDoubleX(), corner2.getDoubleY() - corner1.getDoubleY(), startAngle, arcAngle, color, canvas);
    }

    public FilledArc(Location corner1, Location corner2, double startAngle, double arcAngle, DrawingCanvas canvas) {
        this(corner1, corner2, startAngle, arcAngle, null, canvas);
    }

    public double getArcAngle() {
        return this.arcAngle;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double a) {
        this.startAngle = a;
        this.update();
    }

    public void setArcAngle(double a) {
        this.arcAngle = a;
        this.update();
    }

    @Override
    public Shape makeShape() {
        return new Arc2D.Double(this.getDoubleX(), this.getDoubleY(), this.getDoubleWidth(), this.getDoubleHeight(), this.startAngle, this.arcAngle, 2);
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width, height);
    }

    @Override
    public void setWidth(double w) {
        super.setWidth(w);
    }

    @Override
    public void setHeight(double h) {
        super.setHeight(h);
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public double getDoubleX() {
        return super.getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return super.getDoubleY();
    }

    @Override
    public Location getLocation() {
        return super.getLocation();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public double getDoubleWidth() {
        return super.getDoubleWidth();
    }

    @Override
    public double getDoubleHeight() {
        return super.getDoubleHeight();
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return super.overlaps(other);
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
    }

    @Override
    public void setColor(Color c, float a) {
        super.setColor(c, a);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        return super.contains(point);
    }

    @Override
    public String toString() {
        return this.toString(", " + Text.formatDecimal(this.startAngle) + ", " + Text.formatDecimal(this.arcAngle));
    }
}

