/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawPolygon;
import coffeedraw.Polygon;
import java.awt.Color;
import java.awt.Shape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class FilledPolygon
extends ObjectDrawPolygon
implements Polygon,
Serializable {
    private int numSides;

    public FilledPolygon(int numSides, double x, double y, double width, double height, double rotation, Color c, DrawingCanvas canvas) {
        super(numSides, x, y, width, height, rotation, true, c, canvas);
        this.numSides = numSides;
        this.ready();
    }

    public FilledPolygon(int numSides, double x, double y, double width, double height, double rotation, DrawingCanvas canvas) {
        super(numSides, x, y, width, height, rotation, true, null, canvas);
        this.numSides = numSides;
        this.ready();
    }

    public FilledPolygon(int numSides, double x, double y, double width, double height, DrawingCanvas canvas) {
        this(numSides, x, y, width, height, 0.0, canvas);
    }

    public FilledPolygon(int numSides, Location loc, double width, double height, double rotation, Color color, DrawingCanvas canvas) {
        this(numSides, loc.getDoubleX(), loc.getDoubleY(), width, height, rotation, color, canvas);
    }

    public FilledPolygon(int numSides, Location loc, double width, double height, double rotation, DrawingCanvas canvas) {
        this(numSides, loc.getDoubleX(), loc.getDoubleY(), width, height, rotation, null, canvas);
    }

    public FilledPolygon(int numSides, double x, double y, double width, double height, Color c, DrawingCanvas canvas) {
        this(numSides, x, y, width, height, 0.0, c, canvas);
    }

    public FilledPolygon(int numSides, Location loc, double width, double height, DrawingCanvas canvas) {
        this(numSides, loc.getDoubleX(), loc.getDoubleY(), width, height, 0.0, null, canvas);
    }

    public FilledPolygon(Location[] points, double x, double y, double rotation, Color c, DrawingCanvas canvas) {
        super(points, x, y, rotation, true, c, canvas);
    }

    public FilledPolygon(Location[] points, double x, double y, double rotation, DrawingCanvas canvas) {
        this(points, x, y, rotation, null, canvas);
    }

    public FilledPolygon(Location[] points, double x, double y, Color c, DrawingCanvas canvas) {
        this(points, x, y, 0.0, c, canvas);
    }

    public FilledPolygon(Location[] points, double x, double y, DrawingCanvas canvas) {
        this(points, x, y, 0.0, null, canvas);
    }

    public FilledPolygon(Location[] points, Location loc, double rotation, Color c, DrawingCanvas canvas) {
        this(points, loc.getDoubleX(), loc.getDoubleY(), rotation, c, canvas);
    }

    public FilledPolygon(ArrayList<Location> points, double x, double y, double rotation, Color c, DrawingCanvas canvas) {
        super(points.toArray(new Location[points.size()]), x, y, rotation, true, c, canvas);
    }

    public FilledPolygon(ArrayList<Location> points, Location loc, double rotation, Color c, DrawingCanvas canvas) {
        this(points, loc.getDoubleX(), loc.getDoubleY(), rotation, c, canvas);
    }

    public FilledPolygon(ArrayList<Location> points, Location loc, Color c, DrawingCanvas canvas) {
        this(points, loc.getDoubleX(), loc.getDoubleY(), 0.0, c, canvas);
    }

    public FilledPolygon(ArrayList<Location> points, double x, double y, double rotation, DrawingCanvas canvas) {
        this(points, x, y, rotation, null, canvas);
    }

    public FilledPolygon(ArrayList<Location> points, double x, double y, DrawingCanvas canvas) {
        this(points, x, y, 0.0, canvas);
    }

    @Override
    public Shape makeShape() {
        ArrayList points;
        ArrayList arrayList = points = this.regular ? new ArrayList() : (ArrayList)Arrays.asList(this.getPoints());
        if (this.regular) {
            double theta;
            double radius = this.getDoubleWidth() / 2.0;
            double angle = 180 - 360 / this.getSides();
            angle = theta = Math.PI * 2 / (double)this.getSides();
            Location startLoc = new Location((double)this.getX() + this.getDoubleWidth() / 2.0, (double)this.getY() + this.getDoubleHeight() / 2.0);
            Location loc = new Location(startLoc);
            int i = 0;
            while (i < this.getSides()) {
                Location newLoc = new Location(startLoc);
                newLoc.translate(radius * Math.cos(angle * (double)i), radius * Math.sin(angle * (double)i));
                points.add(newLoc);
                ++i;
            }
        }
        java.awt.Polygon poly = new java.awt.Polygon();
        for (Location l : points) {
            poly.addPoint(l.getX(), l.getY());
        }
        return poly;
    }

    @Override
    public int getNumSides() {
        return this.numSides;
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width, height);
    }

    @Override
    public void setWidth(double w) {
        super.setWidth(w);
    }

    @Override
    public void setHeight(double h) {
        super.setHeight(h);
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public double getDoubleX() {
        return super.getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return super.getDoubleY();
    }

    @Override
    public Location getLocation() {
        return super.getLocation();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public double getDoubleWidth() {
        return super.getDoubleWidth();
    }

    @Override
    public double getDoubleHeight() {
        return super.getDoubleHeight();
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return super.overlaps(other);
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
    }

    @Override
    public void setColor(Color c, float a) {
        super.setColor(c, a);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        return super.contains(point);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void rotate(double r) {
        super.rotate(r);
    }
}

