/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawRectangularShape;
import coffeedraw.Rounded;
import coffeedraw.Text;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.io.Serializable;

public class FilledRoundedRect
extends ObjectDrawRectangularShape
implements Rounded,
Serializable {
    private double arcWidth;
    private double arcHeight;

    public FilledRoundedRect(double x, double y, double width, double height, double arcWidth, double arcHeight, Color color, DrawingCanvas canvas) {
        super(x, y, width, height, true, color, canvas);
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.ready();
    }

    public FilledRoundedRect(double x, double y, double width, double height, double arcWidth, double arcHeight, DrawingCanvas canvas) {
        this(x, y, width, height, arcWidth, arcHeight, null, canvas);
    }

    public FilledRoundedRect(Location point, double width, double height, double arcWidth, double arcHeight, Color color, DrawingCanvas canvas) {
        this(point.getDoubleX(), point.getDoubleY(), width, height, arcWidth, arcHeight, color, canvas);
    }

    public FilledRoundedRect(Location point, double width, double height, double arcWidth, double arcHeight, DrawingCanvas canvas) {
        this(point, width, height, arcWidth, arcHeight, null, canvas);
    }

    public FilledRoundedRect(Location corner1, Location corner2, double arcWidth, double arcHeight, Color color, DrawingCanvas canvas) {
        this(corner1, corner2.getDoubleX() - corner1.getDoubleX(), corner2.getDoubleY() - corner1.getDoubleY(), arcWidth, arcHeight, color, canvas);
    }

    public FilledRoundedRect(Location corner1, Location corner2, double arcWidth, double arcHeight, DrawingCanvas canvas) {
        this(corner1, corner2, arcWidth, arcHeight, null, canvas);
    }

    @Override
    public int getArcHeight() {
        return (int)(this.arcHeight + 0.5);
    }

    @Override
    public double getDoubleArcHeight() {
        return this.arcHeight;
    }

    @Override
    public int getArcWidth() {
        return (int)(this.arcWidth + 0.5);
    }

    @Override
    public double getDoubleArcWidth() {
        return this.arcWidth;
    }

    @Override
    public void setArcWidth(double a) {
        this.arcWidth = a;
        this.update();
    }

    @Override
    public void setArcHeight(double a) {
        this.arcHeight = a;
        this.update();
    }

    @Override
    public Shape makeShape() {
        return new RoundRectangle2D.Double(this.getDoubleX(), this.getDoubleY(), this.getDoubleWidth(), this.getDoubleHeight(), this.arcWidth, this.arcHeight);
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width, height);
    }

    @Override
    public void setWidth(double w) {
        super.setWidth(w);
    }

    @Override
    public void setHeight(double h) {
        super.setHeight(h);
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public double getDoubleX() {
        return super.getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return super.getDoubleY();
    }

    @Override
    public Location getLocation() {
        return super.getLocation();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public double getDoubleWidth() {
        return super.getDoubleWidth();
    }

    @Override
    public double getDoubleHeight() {
        return super.getDoubleHeight();
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return super.overlaps(other);
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
    }

    @Override
    public void setColor(Color c, float a) {
        super.setColor(c, a);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        return super.contains(point);
    }

    @Override
    public String toString() {
        return this.toString(", " + Text.formatDecimal(this.arcWidth) + ", " + Text.formatDecimal(this.arcHeight));
    }
}

