/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawableStrokeInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawRectangularShape;
import coffeedraw.Text;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.io.Serializable;

public class FramedArc
extends ObjectDrawRectangularShape
implements DrawableStrokeInterface,
Serializable {
    private double startAngle;
    private double arcAngle;
    private BasicStroke stroke;

    public FramedArc(double x, double y, double width, double height, double startAngle, double arcAngle, Color color, DrawingCanvas canvas) {
        super(x, y, width, height, false, color, canvas);
        this.startAngle = startAngle;
        this.arcAngle = arcAngle;
        this.stroke = DEFAULT_STROKE;
        this.ready();
    }

    public FramedArc(double x, double y, double width, double height, double startAngle, double arcAngle, DrawingCanvas canvas) {
        this(x, y, width, height, startAngle, arcAngle, null, canvas);
    }

    public FramedArc(Location point, double width, double height, double startAngle, double arcAngle, Color color, DrawingCanvas canvas) {
        this(point.getDoubleX(), point.getDoubleY(), width, height, startAngle, arcAngle, color, canvas);
    }

    public FramedArc(Location point, double width, double height, double startAngle, double arcAngle, DrawingCanvas canvas) {
        this(point, width, height, startAngle, arcAngle, null, canvas);
    }

    public FramedArc(Location corner1, Location corner2, double startAngle, double arcAngle, Color color, DrawingCanvas canvas) {
        this(corner1, corner2.getDoubleX() - corner1.getDoubleX(), corner2.getDoubleY() - corner1.getDoubleY(), startAngle, arcAngle, color, canvas);
    }

    public FramedArc(Location corner1, Location corner2, double startAngle, double arcAngle, DrawingCanvas canvas) {
        this(corner1, corner2, startAngle, arcAngle, null, canvas);
    }

    public double getArcAngle() {
        return this.arcAngle;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double a) {
        this.startAngle = a;
        this.update();
    }

    public void setArcAngle(double a) {
        this.arcAngle = a;
        this.update();
    }

    @Override
    public Shape makeShape() {
        return new Arc2D.Double(this.getDoubleX(), this.getDoubleY(), this.getDoubleWidth(), this.getDoubleHeight(), this.startAngle, this.arcAngle, 0);
    }

    @Override
    public double getLineWidth() {
        return this.stroke.getLineWidth();
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setLineWidth(double width) {
        this.stroke = new BasicStroke((float)width, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.update();
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        this.update();
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width, height);
    }

    @Override
    public void setWidth(double w) {
        super.setWidth(w);
    }

    @Override
    public void setHeight(double h) {
        super.setHeight(h);
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public double getDoubleX() {
        return super.getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return super.getDoubleY();
    }

    @Override
    public Location getLocation() {
        return super.getLocation();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public double getDoubleWidth() {
        return super.getDoubleWidth();
    }

    @Override
    public double getDoubleHeight() {
        return super.getDoubleHeight();
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return super.overlaps(other);
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
    }

    @Override
    public void setColor(Color c, float a) {
        super.setColor(c, a);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        double w = this.getDoubleWidth();
        double h = this.getDoubleHeight();
        double c = Math.PI * (3.0 * (w + h) + Math.sqrt((3.0 * w + h) * (w + 3.0 * h))) / 2.0;
        double err = Math.PI / c;
        double cx = this.getDoubleX() + w / 2.0;
        double cy = this.getDoubleY() + h / 2.0;
        double x = point.getDoubleX();
        double y = point.getDoubleY();
        double sa = this.startAngle * Math.PI / 180.0;
        double da = this.arcAngle * Math.PI / 180.0;
        while (da > err) {
            double dy;
            double ma = sa + da / 2.0;
            double dx = cx + Math.cos(-ma) * w / 2.0 - x;
            double d = Math.sqrt(dx * dx + (dy = cy + Math.sin(-ma) * h / 2.0 - y) * dy);
            if (d < 4.0) {
                return true;
            }
            if (da * w * Math.sin(-ma) * dx - da * h * Math.cos(-ma) * dy < 0.0) {
                sa = ma;
            }
            da /= 2.0;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.toString(", " + Text.formatDecimal(this.startAngle) + ", " + Text.formatDecimal(this.arcAngle));
    }
}

