/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawableStrokeInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawRectangularShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class FramedRect
extends ObjectDrawRectangularShape
implements DrawableStrokeInterface,
Serializable {
    private BasicStroke stroke = DEFAULT_STROKE;

    public FramedRect(double x, double y, double width, double height, Color color, DrawingCanvas canvas) {
        super(x, y, width, height, false, color, canvas);
        this.ready();
    }

    public FramedRect(double x, double y, double width, double height, DrawingCanvas canvas) {
        this(x, y, width, height, null, canvas);
    }

    public FramedRect(Location point, double width, double height, Color color, DrawingCanvas canvas) {
        this(point.getDoubleX(), point.getDoubleY(), width, height, color, canvas);
    }

    public FramedRect(Location point, double width, double height, DrawingCanvas canvas) {
        this(point, width, height, null, canvas);
    }

    public FramedRect(Location corner1, Location corner2, Color color, DrawingCanvas canvas) {
        this(corner1, corner2.getDoubleX() - corner1.getDoubleX(), corner2.getDoubleY() - corner1.getDoubleY(), color, canvas);
    }

    public FramedRect(Location corner1, Location corner2, DrawingCanvas canvas) {
        this(corner1, corner2, null, canvas);
    }

    public FramedRect(double x, double y, double width, double height, double angle, Color color, DrawingCanvas canvas) {
        super(x, y, width, height, angle, true, color, canvas);
        this.ready();
    }

    public FramedRect(Location location, double width, double height, double angle, Color color, DrawingCanvas canvas) {
        super(location.getDoubleX(), location.getDoubleY(), width, height, angle, true, color, canvas);
        this.ready();
    }

    public FramedRect(double x, double y, double width, double height, double angle, DrawingCanvas canvas) {
        this(x, y, width, height, angle, null, canvas);
    }

    @Override
    public Shape makeShape() {
        return new Rectangle2D.Double(this.getDoubleX(), this.getDoubleY(), this.getDoubleWidth(), this.getDoubleHeight());
    }

    @Override
    public double getLineWidth() {
        return this.stroke.getLineWidth();
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setLineWidth(double width) {
        this.stroke = new BasicStroke((float)width, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.update();
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        this.update();
    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width, height);
    }

    @Override
    public void setWidth(double w) {
        super.setWidth(w);
    }

    @Override
    public void setHeight(double h) {
        super.setHeight(h);
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public double getDoubleX() {
        return super.getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return super.getDoubleY();
    }

    @Override
    public Location getLocation() {
        return super.getLocation();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public double getDoubleWidth() {
        return super.getDoubleWidth();
    }

    @Override
    public double getDoubleHeight() {
        return super.getDoubleHeight();
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return super.overlaps(other);
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
    }

    @Override
    public void setColor(Color c, float a) {
        super.setColor(c, a);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        return super.contains(point);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

