/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.DrawingCanvas;
import coffeedraw.ObjectDrawObject;
import coffeedraw.ObjectDrawShape;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;

public class KeyInterpreter
implements KeyListener {
    private static HashMap codeNames;
    private static HashMap keyCodes;
    private Object target;
    private HashSet keysDown = new HashSet();
    private Component canvas;

    static {
        keyCodes = KeyInterpreter.buildKeyCodes();
    }

    public KeyInterpreter(Object target, DrawingCanvas canvas) {
        this.canvas = (Component)((Object)canvas);
        this.canvas.addKeyListener(this);
        this.target = target;
    }

    public void removeFromCanvas() {
        if (this.canvas != null) {
            this.canvas.removeKeyListener(this);
            this.canvas = null;
        }
    }

    public void addToCanvas(DrawingCanvas canvas) {
        if (canvas != this.canvas) {
            this.removeFromCanvas();
            this.canvas = (Component)((Object)canvas);
            this.canvas.addKeyListener(this);
        }
    }

    public DrawingCanvas getCanvas() {
        return (DrawingCanvas)((Object)this.canvas);
    }

    private static HashMap buildKeyCodes() {
        HashMap<String, Integer> keyCodes = new HashMap<String, Integer>();
        codeNames = new HashMap();
        try {
            Field[] fields = KeyEvent.class.getFields();
            int i = 0;
            while (i < fields.length) {
                if ((fields[i].getModifiers() & 8) != 0 && fields[i].getName().startsWith("VK_")) {
                    String name = fields[i].getName().substring(3).toLowerCase();
                    Integer value = (Integer)fields[i].get(null);
                    keyCodes.put(name, value);
                    codeNames.put(value, name);
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return keyCodes;
    }

    private static Integer codeForKeyName(String key) {
        return (Integer)keyCodes.get(key.toLowerCase());
    }

    private static String nameForKeyCode(Integer code) {
        return (String)codeNames.get(code);
    }

    private static String uppercaseNameForKeyCode(Integer code) {
        return ((String)codeNames.get(code)).toUpperCase();
    }

    private static String capitalizedNameForKeyCode(Integer code) {
        String s = (String)codeNames.get(code);
        return s.substring(0, 1).toUpperCase().concat(s.substring(1));
    }

    private void keyEvent(KeyEvent event) {
        String type;
        Integer code = new Integer(event.getKeyCode());
        if (this.target == null) {
            return;
        }
        if (event.getID() == 401) {
            if (this.keysDown.contains(code)) {
                type = "Hold";
            } else {
                type = "Press";
                this.keysDown.add(code);
            }
        } else if (event.getID() == 402) {
            type = "Release";
            this.keysDown.remove(code);
        } else {
            return;
        }
        String name = KeyInterpreter.capitalizedNameForKeyCode(code);
        if (name == null) {
            return;
        }
        String methodName = "on" + name + type;
        ObjectDrawObject.deferUpdates();
        try {
            try {
                Method method = this.target.getClass().getMethod(methodName, null);
                method.invoke(this.target, null);
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                ObjectDrawObject.runUpdates();
            }
            catch (Exception e) {
                try {
                    Class[] c = new Class[]{String.class};
                    Object[] key = new String[]{event.isShiftDown() ? KeyInterpreter.capitalizedNameForKeyCode(code) : KeyInterpreter.nameForKeyCode(code)};
                    if (event.isAltDown()) {
                        key[0] = "~" + key[0];
                    }
                    if (event.isControlDown()) {
                        key[0] = "^" + key[0];
                    }
                    if (event.isMetaDown()) {
                        key[0] = "&" + key[0];
                    }
                    Method method = this.target.getClass().getMethod("onOther" + type, c);
                    method.invoke(this.target, key);
                }
                catch (InvocationTargetException f) {
                    e.getCause().printStackTrace();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ObjectDrawObject.runUpdates();
            }
        }
        finally {
            ObjectDrawObject.runUpdates();
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (this.target == null || event.isActionKey() || event.getKeyChar() == '\uffff' || event.getKeyChar() != '\n' && Character.isISOControl(event.getKeyChar())) {
            return;
        }
        ObjectDrawShape.deferUpdates();
        try {
            try {
                Class[] c = new Class[]{String.class};
                Object[] key = new String[]{"" + event.getKeyChar()};
                Method method = this.target.getClass().getMethod("onKeyTyped", c);
                method.invoke(this.target, key);
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                ObjectDrawObject.runUpdates();
            }
            catch (Exception exception) {
                ObjectDrawObject.runUpdates();
            }
        }
        finally {
            ObjectDrawObject.runUpdates();
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.keyEvent(event);
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.keyEvent(event);
    }
}

