/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable1DInterface;
import coffeedraw.DrawableStrokeInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawShape;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;

public class Line
extends ObjectDrawShape
implements Drawable1DInterface,
DrawableStrokeInterface {
    private Location end;
    private BasicStroke stroke;

    public Line(double x1, double y1, double x2, double y2, Color color, DrawingCanvas canvas) {
        super(new Location(x1, y1), false, color, canvas);
        this.end = new Location(x2, y2);
        this.end.depend(this);
        this.stroke = DEFAULT_STROKE;
        this.ready();
    }

    public Line(double x1, double y1, double x2, double y2, float thickness, Color color, DrawingCanvas canvas) {
        super(new Location(x1, y1), false, color, canvas);
        this.end = new Location(x2, y2);
        this.end.depend(this);
        this.stroke = new BasicStroke(thickness, 1, 1);
        this.ready();
    }

    public Line(double x1, double y1, double x2, double y2, float thickness, DrawingCanvas canvas) {
        this(x1, y1, x2, y2, thickness, null, canvas);
    }

    public Line(double x1, double y1, double x2, double y2, DrawingCanvas canvas) {
        this(x1, y1, x2, y2, null, canvas);
    }

    public Line(Location start, Location end, Color color, DrawingCanvas canvas) {
        this(start.getDoubleX(), start.getDoubleY(), end.getDoubleX(), end.getDoubleY(), color, canvas);
    }

    public Line(Location start, Location end, DrawingCanvas canvas) {
        this(start, end, null, canvas);
    }

    @Override
    public Shape makeShape() {
        Location start = this.getStart();
        return new Line2D.Double(start.getDoubleX(), start.getDoubleY(), this.end.getDoubleX(), this.end.getDoubleY());
    }

    @Override
    public double getLineWidth() {
        return this.stroke.getLineWidth();
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setLineWidth(double width) {
        this.stroke = new BasicStroke((float)width, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.update();
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        this.update();
    }

    @Override
    public Location getStart() {
        return this.getMyLocation();
    }

    @Override
    public Location getEnd() {
        return this.end;
    }

    @Override
    public void setStart(Location point) {
        this.setStart(point.getDoubleX(), point.getDoubleY());
    }

    @Override
    public void setStart(double x, double y) {
        Location start = this.getStart();
        start.translate(x - start.getDoubleX(), y - start.getDoubleY());
    }

    @Override
    public void setEnd(Location point) {
        this.setEnd(point.getDoubleX(), point.getDoubleY());
    }

    @Override
    public void setEnd(double x, double y) {
        this.end.translate(x - this.end.getDoubleX(), y - this.end.getDoubleY());
    }

    @Override
    public void setEndPoints(Location start, Location end) {
        this.setStart(start);
        this.setEnd(end);
    }

    @Override
    public void setEndPoints(double x1, double y1, double x2, double y2) {
        this.setStart(x1, y1);
        this.setEnd(x2, y2);
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
        this.end.translate(dx, dy);
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
    }

    @Override
    public void setColor(Color c, float a) {
        super.setColor(c, a);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        double rx = point.getDoubleX() - this.getStart().getDoubleX();
        double ry = point.getDoubleY() - this.getStart().getDoubleY();
        double r2x = point.getDoubleX() - this.end.getDoubleX();
        double r2y = point.getDoubleY() - this.end.getDoubleY();
        if (Math.max(Math.abs(rx), Math.abs(ry)) < 4.0 && Math.sqrt(rx * rx + ry * ry) < 4.0) {
            return true;
        }
        if (Math.max(Math.abs(r2x), Math.abs(r2y)) < 4.0 && Math.sqrt(r2x * r2x + r2y * r2y) < 4.0) {
            return true;
        }
        double length = this.getStart().distanceTo(this.end);
        double dx = this.end.getDoubleX() - this.getStart().getDoubleX();
        double dy = this.end.getDoubleY() - this.getStart().getDoubleY();
        double parameter = (rx * dx + ry * dy) / length;
        double offset = Math.abs((rx * -dy + ry * dx) / length);
        return parameter >= 0.0 && parameter <= length && offset <= 4.0;
    }

    @Override
    public String toString() {
        return this.toString(this.getStart() + ", " + this.getEnd());
    }
}

