/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawObject;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MouseInterpreter
implements MouseListener,
MouseMotionListener {
    private Component canvas;
    private Object target;

    public MouseInterpreter(Object target, DrawingCanvas canvas) {
        this.canvas = (Component)((Object)canvas);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.target = target;
    }

    public void removeFromCanvas() {
        if (this.canvas != null) {
            this.canvas.removeMouseListener(this);
            this.canvas.removeMouseMotionListener(this);
            this.canvas = null;
        }
    }

    public void addToCanvas(DrawingCanvas canvas) {
        this.removeFromCanvas();
        this.canvas = (Component)((Object)canvas);
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
    }

    public DrawingCanvas getCanvas() {
        return (DrawingCanvas)((Object)this.canvas);
    }

    private void mouseEvent(MouseEvent event, String type) {
        if (this.target == null) {
            return;
        }
        ObjectDrawObject.deferUpdates();
        Location point = new Location(event.getX(), event.getY());
        String methodName = "onMouse" + type;
        try {
            try {
                Method method = this.target.getClass().getMethod(methodName, Location.class);
                method.invoke(this.target, point);
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
                ObjectDrawObject.runUpdates();
            }
            catch (Exception exception) {
                ObjectDrawObject.runUpdates();
            }
        }
        finally {
            ObjectDrawObject.runUpdates();
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.mouseEvent(event, "Drag");
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.mouseEvent(event, "Move");
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.mouseEvent(event, "Click");
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.canvas.requestFocus();
        this.mouseEvent(event, "Press");
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.mouseEvent(event, "Release");
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.mouseEvent(event, "Enter");
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.mouseEvent(event, "Exit");
    }
}

