/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

abstract class NetworkThread
implements Runnable {
    private static final int MAX_MESSAGE_LENGTH = 65536;
    private static final String LOST = new String("Lost");
    private static final int IDLE_SLEEP_TIME = 10;
    static final String CHARSET_NAME = "ISO-8859-1";
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final boolean DEBUG = false;
    private final CharsetEncoder encoder = CHARSET.newEncoder();
    private final CharsetDecoder decoder = CHARSET.newDecoder();
    private final List channelChanges = Collections.synchronizedList(new LinkedList());
    private final List messagesToWrite = Collections.synchronizedList(new LinkedList());
    private final ArrayList channels = new ArrayList();
    private final LinkedList POOL = new LinkedList();
    private final CharBuffer readCharBuffer = CharBuffer.allocate(65536);
    final Selector selector = Selector.open();
    private final String name;
    private final Message nameMessage;
    private boolean running = false;
    private int nextID = 0;

    private Message encodeShortMessage(String string) {
        CharBuffer input = CharBuffer.wrap(string);
        Message message = this.createMessage();
        ByteBuffer buffer = message.buffer;
        buffer.position(2);
        this.encoder.reset();
        this.encoder.encode(input, buffer, true);
        this.encoder.flush(buffer);
        int length = buffer.position();
        buffer.flip();
        buffer.put((byte)(length >> 8));
        buffer.put((byte)(length & 0xFF));
        buffer.rewind();
        return message;
    }

    public String getName() {
        return this.name;
    }

    void start() {
        new Thread(this).start();
    }

    NetworkThread(String name) throws IOException {
        this.name = name;
        this.nameMessage = this.encodeShortMessage(name);
        this.nameMessage.retainCount = -1;
    }

    private void release(Message message) {
        if (--message.retainCount == 0) {
            this.POOL.add(message);
        }
    }

    private Message createMessage() {
        Message message = this.POOL.isEmpty() ? new Message() : (Message)this.POOL.removeFirst();
        message.buffer.clear();
        return message;
    }

    private String decode(ArrayList messages) {
        this.readCharBuffer.clear();
        this.decoder.reset();
        ((Message)messages.get((int)0)).buffer.position(2);
        int i = 0;
        while (i < messages.size()) {
            ByteBuffer buffer = ((Message)messages.get((int)i)).buffer;
            if (i == messages.size() - 1) {
                this.decoder.decode(buffer, this.readCharBuffer, true);
            } else {
                this.decoder.decode(buffer, this.readCharBuffer, false);
            }
            ++i;
        }
        this.decoder.flush(this.readCharBuffer);
        this.readCharBuffer.flip();
        return this.readCharBuffer.toString();
    }

    private ArrayList encode(String string, int retainCount) {
        CharBuffer input = CharBuffer.wrap(string);
        ArrayList<Message> messages = new ArrayList<Message>();
        Message firstMessage = this.createMessage();
        firstMessage.buffer.position(2);
        messages.add(firstMessage);
        firstMessage.retainCount = retainCount;
        Message message = firstMessage;
        int length = 0;
        this.encoder.reset();
        CoderResult result = this.encoder.encode(input, message.buffer, true);
        while (result.isOverflow()) {
            length += message.buffer.position();
            message.buffer.flip();
            message = this.createMessage();
            messages.add(message);
            message.retainCount = retainCount;
            result = this.encoder.encode(input, message.buffer, true);
        }
        result = this.encoder.flush(message.buffer);
        while (result.isOverflow()) {
            length += message.buffer.position();
            message.buffer.flip();
            message = this.createMessage();
            messages.add(message);
            message.retainCount = retainCount;
            result = this.encoder.flush(message.buffer);
        }
        message.buffer.flip();
        firstMessage.buffer.put((byte)((length += message.buffer.position()) >> 8));
        firstMessage.buffer.put((byte)(length & 0xFF));
        firstMessage.buffer.rewind();
        return messages;
    }

    private Channel getChannel(int id) {
        if (this.channels.isEmpty()) {
            return null;
        }
        int max = Math.min(id + 1, this.channels.size());
        int min = 0;
        while (min + 1 != max) {
            int mid = (max + min) / 2;
            if (id >= ((Channel)this.channels.get((int)mid)).id) {
                min = mid;
                continue;
            }
            max = mid;
        }
        Channel found = (Channel)this.channels.get(min);
        return found.id == id ? found : null;
    }

    abstract void messageReceived(int var1, String var2, String var3);

    abstract void channelClosed(int var1, String var2);

    abstract void channelReady(int var1, String var2);

    void updateChannelLater(SelectableChannel channel, int interestOps, int changeMask) {
        SelectionKey key = channel.keyFor(this.selector);
        this.channelChanges.add(new ChannelUpdate(key, interestOps, changeMask));
    }

    public void shutDown() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    void enqueueMessage(String message, int channelID) {
        this.messagesToWrite.add(new PendingMessage(message, channelID));
        this.selector.wakeup();
    }

    private void handlePendingMessages() {
        while (!this.channelChanges.isEmpty()) {
            ChannelUpdate update = (ChannelUpdate)this.channelChanges.remove(0);
            update.key.interestOps(update.key.interestOps() & ~update.changeMask | update.interestOps & update.changeMask);
        }
        while (!this.messagesToWrite.isEmpty()) {
            PendingMessage message = (PendingMessage)this.messagesToWrite.remove(0);
            if (message.channel < 0) {
                if (this.channels.isEmpty()) continue;
                ArrayList messages = this.encode(message.message, this.channels.size());
                int i = 0;
                while (i < this.channels.size()) {
                    Channel channel = (Channel)this.channels.get(i);
                    if (!channel.enqueue(messages)) {
                        --i;
                    }
                    ++i;
                }
                continue;
            }
            Channel channel = this.getChannel(message.channel);
            if (channel == null) continue;
            channel.enqueue(this.encode(message.message, 1));
        }
    }

    private void newChannel(SocketChannel socketChannel) {
        try {
            socketChannel.configureBlocking(false);
            Channel channel = new Channel(socketChannel);
            SelectionKey key = socketChannel.keyFor(this.selector);
            if (key == null) {
                socketChannel.register(this.selector, 5, channel);
            } else {
                key.attach(channel);
                key.interestOps(5);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void performSelection() {
        block13: {
            try {
                if (this.selector.select() != 0) break block13;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        Iterator<SelectionKey> iter = this.selector.selectedKeys().iterator();
        while (iter.hasNext()) {
            Object channel;
            SelectionKey key = iter.next();
            iter.remove();
            if (key.isAcceptable()) {
                try {
                    this.newChannel(((ServerSocketChannel)key.channel()).accept());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (key.isConnectable()) {
                channel = (SocketChannel)key.channel();
                try {
                    if (!((SocketChannel)channel).finishConnect()) {
                        throw new RuntimeException("Connection failed to finish.");
                    }
                    this.newChannel((SocketChannel)channel);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            channel = (ChannelHandler)key.attachment();
            if (channel == null) continue;
            if (key.isReadable()) {
                channel.read();
            }
            if (!key.isValid() || !key.isWritable()) continue;
            channel.write();
        }
    }

    void closeAll() {
        try {
            this.selector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (!this.channels.isEmpty()) {
            ((Channel)this.channels.get(this.channels.size() - 1)).close();
        }
    }

    boolean setup() {
        return true;
    }

    void tearDown() {
    }

    @Override
    public void run() {
        this.running = this.setup();
        while (this.running) {
            try {
                this.handlePendingMessages();
                this.performSelection();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        this.tearDown();
        this.closeAll();
    }

    private class Channel
    implements ChannelHandler {
        private String name = null;
        private final int id;
        private final ArrayList readBuffers = new ArrayList();
        private final LinkedList writeQueue = new LinkedList();
        private final SocketChannel channel;
        private int remainingReadLength;
        private int writePosition;

        public Channel(SocketChannel channel) {
            this.channel = channel;
            this.readBuffers.add(NetworkThread.this.createMessage());
            this.remainingReadLength = -1;
            this.writeQueue.add(NetworkThread.this.nameMessage);
            this.writePosition = -1;
            this.id = NetworkThread.this.nextID++;
            NetworkThread.this.channels.add(this);
        }

        private void setWriteInterest(boolean interested) {
            SelectionKey key = this.channel.keyFor(NetworkThread.this.selector);
            key.interestOps(interested ? key.interestOps() | 4 : key.interestOps() & 0xFFFFFFFB);
        }

        public boolean enqueue(ArrayList messages) {
            if (!this.channel.isOpen()) {
                this.close();
                return false;
            }
            if (this.writeQueue.isEmpty()) {
                this.setWriteInterest(true);
            }
            this.writeQueue.addAll(messages);
            return true;
        }

        public boolean readOnePage() throws IOException {
            boolean moreToRead;
            ByteBuffer buffer = ((Message)this.readBuffers.get((int)(this.readBuffers.size() - 1))).buffer;
            int readBytes = this.channel.read(buffer);
            if (readBytes == -1) {
                this.close();
                return false;
            }
            if (readBytes == 0) {
                return false;
            }
            int position = buffer.position();
            boolean bl = moreToRead = position == buffer.capacity();
            if (this.remainingReadLength == -1) {
                if (position < 2) {
                    return false;
                }
                buffer.position(0);
                this.remainingReadLength = (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
                buffer.position(position);
            }
            if (position == this.remainingReadLength) {
                buffer.flip();
                this.finishRead();
                this.readBuffers.add(NetworkThread.this.createMessage());
                this.remainingReadLength = -1;
            } else if (position > this.remainingReadLength) {
                while (position >= this.remainingReadLength) {
                    Message nextMessage = NetworkThread.this.createMessage();
                    buffer.flip();
                    if (position > this.remainingReadLength) {
                        buffer.position(this.remainingReadLength);
                        nextMessage.buffer.put(buffer);
                        buffer.rewind();
                        buffer.limit(this.remainingReadLength);
                    }
                    this.finishRead();
                    this.readBuffers.add(nextMessage);
                    buffer = nextMessage.buffer;
                    position = buffer.position();
                    if (position >= 2) {
                        buffer.position(0);
                        this.remainingReadLength = (buffer.get() & 0xFF) << 8 | buffer.get() & 0xFF;
                        buffer.position(position);
                        continue;
                    }
                    this.remainingReadLength = -1;
                    break;
                }
            } else if (moreToRead) {
                buffer.flip();
                this.remainingReadLength -= position;
                this.readBuffers.add(NetworkThread.this.createMessage());
            }
            return moreToRead;
        }

        private void finishRead() {
            if (this.name == null) {
                this.name = NetworkThread.this.decode(this.readBuffers);
                NetworkThread.this.channelReady(this.id, this.name);
            } else {
                NetworkThread.this.messageReceived(this.id, this.name, NetworkThread.this.decode(this.readBuffers));
            }
            NetworkThread.this.POOL.addAll(this.readBuffers);
            this.readBuffers.clear();
        }

        @Override
        public void read() {
            try {
                while (this.readOnePage()) {
                }
            }
            catch (IOException e) {
                this.close();
                e.printStackTrace();
                return;
            }
        }

        public void close() {
            NetworkThread.this.channelClosed(this.id, this.name);
            NetworkThread.this.channels.remove(this);
            while (!this.writeQueue.isEmpty()) {
                NetworkThread.this.release((Message)this.writeQueue.removeFirst());
            }
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void write() {
            try {
                while (!this.writeQueue.isEmpty()) {
                    ByteBuffer buffer = ((Message)this.writeQueue.getFirst()).buffer;
                    if (this.writePosition >= 0) {
                        buffer.position(this.writePosition);
                        this.writePosition = -1;
                    } else {
                        buffer.rewind();
                    }
                    try {
                        this.channel.write(buffer);
                    }
                    catch (ClosedChannelException e) {
                        this.close();
                        return;
                    }
                    if (buffer.remaining() > 0) {
                        this.writePosition = buffer.position();
                        return;
                    }
                    NetworkThread.this.release((Message)this.writeQueue.removeFirst());
                }
                this.setWriteInterest(false);
            }
            catch (IOException e) {
                this.close();
                e.printStackTrace();
                return;
            }
        }
    }

    static interface ChannelHandler {
        public void read();

        public void write();
    }

    private class ChannelUpdate {
        private final SelectionKey key;
        private final int interestOps;
        private final int changeMask;

        public ChannelUpdate(SelectionKey key, int interestOps, int changeMask) {
            this.key = key;
            this.interestOps = interestOps;
            this.changeMask = changeMask;
        }
    }

    private class Message {
        final ByteBuffer buffer = ByteBuffer.allocateDirect(1024);
        int retainCount = 0;

        private Message() {
        }
    }

    private static class PendingMessage {
        public final String message;
        public final int channel;

        public PendingMessage(String message, int channel) {
            this.message = message;
            this.channel = channel;
        }
    }
}

