/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawShape;
import coffeedraw.Resizable2DInterface;
import coffeedraw.Text;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public abstract class ObjectDrawPolygon
extends ObjectDrawShape
implements Drawable2DInterface,
Resizable2DInterface,
Serializable {
    private double width;
    private double height;
    private int sides = 3;
    private double angle;
    protected boolean regular = true;
    private Location[] points;

    public ObjectDrawPolygon(int numSides, double x, double y, double width, double height, boolean filled, Color c, DrawingCanvas canvas) {
        super(new Location(width < 0.0 ? x + width : x, height < 0.0 ? y + height : y), filled, c, canvas);
        this.getMyLocation().depend(this);
        this.sides = numSides;
        if (this.sides < 3) {
            this.sides = 3;
        }
        this.width = Math.abs(width);
        this.height = Math.abs(height);
    }

    public ObjectDrawPolygon(int numSides, double x, double y, double width, double height, double rotation, boolean filled, Color c, DrawingCanvas canvas) {
        super(new Location(width < 0.0 ? x + width : x, height < 0.0 ? y + height : y), rotation, filled, c, canvas);
        this.getMyLocation().depend(this);
        this.sides = numSides;
        if (this.sides < 3) {
            this.sides = 3;
        }
        this.width = Math.abs(width);
        this.height = Math.abs(height);
    }

    public ObjectDrawPolygon(Location[] points, double x, double y, double rotation, boolean filled, Color c, DrawingCanvas canvas) {
        super(new Location(x, y), rotation, filled, c, canvas);
        this.getMyLocation().depend(this);
        this.regular = false;
        this.points = points;
        this.width = 0.0;
        this.height = 0.0;
    }

    @Override
    public int getX() {
        return this.getLocation().getX();
    }

    @Override
    public int getY() {
        return this.getLocation().getY();
    }

    @Override
    public double getDoubleX() {
        return this.getLocation().getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return this.getLocation().getDoubleY();
    }

    @Override
    public Location getLocation() {
        return this.getMyLocation();
    }

    public int getSides() {
        return this.sides;
    }

    public Location[] getPoints() {
        return this.points;
    }

    @Override
    public boolean contains(Location point) {
        return this.getShape().contains(point.getDoubleX(), point.getDoubleY());
    }

    @Override
    public void setSize(double w, double h) {
        this.width = w;
        this.height = h;
        this.update();
    }

    @Override
    public void setWidth(double w) {
        this.setSize(w, this.height);
    }

    @Override
    public void setHeight(double h) {
        this.setSize(this.width, h);
    }

    @Override
    public int getWidth() {
        return (int)(this.width + 0.5);
    }

    @Override
    public int getHeight() {
        return (int)(this.height + 0.5);
    }

    @Override
    public double getDoubleWidth() {
        return this.width;
    }

    @Override
    public double getDoubleHeight() {
        return this.height;
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return this.getBounds().intersects(other.getBounds());
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getShape().getBounds2D();
    }

    @Override
    public Shape makeShape() {
        return null;
    }

    @Override
    protected String toString(String middle) {
        return super.toString(String.valueOf(Text.formatDecimal(this.getDoubleX())) + ", " + Text.formatDecimal(this.getDoubleY()) + ", " + Text.formatDecimal(this.width) + ", " + Text.formatDecimal(this.height) + middle);
    }
}

