/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawShape;
import coffeedraw.Resizable2DInterface;
import coffeedraw.Text;
import java.awt.Color;
import java.awt.geom.Rectangle2D;

public abstract class ObjectDrawRectangularShape
extends ObjectDrawShape
implements Drawable2DInterface,
Resizable2DInterface {
    private double width;
    private double height;

    public ObjectDrawRectangularShape(double x, double y, double width, double height, boolean filled, Color c, DrawingCanvas canvas) {
        super(new Location(width < 0.0 ? x + width : x, height < 0.0 ? y + height : y), filled, c, canvas);
        this.getMyLocation().depend(this);
        this.width = Math.abs(width);
        this.height = Math.abs(height);
    }

    public ObjectDrawRectangularShape(double x, double y, double width, double height, double rotation, boolean filled, Color c, DrawingCanvas canvas) {
        super(new Location(width < 0.0 ? x + width : x, height < 0.0 ? y + height : y), rotation, filled, c, canvas);
        this.getMyLocation().depend(this);
        this.width = Math.abs(width);
        this.height = Math.abs(height);
    }

    @Override
    public boolean contains(Location point) {
        return this.getShape().contains(point.getDoubleX(), point.getDoubleY());
    }

    @Override
    public Location getLocation() {
        return this.getMyLocation();
    }

    @Override
    public int getHeight() {
        return (int)(this.height + 0.5);
    }

    @Override
    public double getDoubleHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return (int)(this.width + 0.5);
    }

    @Override
    public double getDoubleWidth() {
        return this.width;
    }

    @Override
    public int getX() {
        return this.getLocation().getX();
    }

    @Override
    public int getY() {
        return this.getLocation().getY();
    }

    @Override
    public double getDoubleX() {
        return this.getLocation().getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return this.getLocation().getDoubleY();
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getShape().getBounds2D();
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return this.getBounds().intersects(other.getBounds());
    }

    @Override
    public void setHeight(double h) {
        this.setSize(this.width, h);
    }

    @Override
    public void setSize(double w, double h) {
        this.width = w;
        this.height = h;
        this.update();
    }

    @Override
    public void setWidth(double w) {
        this.setSize(w, this.height);
    }

    @Override
    public void rotate(double d) {
    }

    @Override
    protected String toString(String middle) {
        return super.toString(String.valueOf(Text.formatDecimal(this.getDoubleX())) + ", " + Text.formatDecimal(this.getDoubleY()) + ", " + Text.formatDecimal(this.width) + ", " + Text.formatDecimal(this.height) + middle);
    }
}

