/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.DrawableInterface;
import coffeedraw.DrawableIterator;
import coffeedraw.DrawableStrokeInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawObject;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ObjectDrawShape
extends ObjectDrawObject
implements DrawableInterface,
Serializable {
    private Color color;
    private boolean filled;
    private boolean hidden;
    private DrawingCanvas canvas;
    private Location location;
    private Shape shape;
    private boolean ready;
    private double angle;
    public boolean ROTATE_FLAG = true;
    static final Color DEFAULT_COLOR = Color.BLACK;
    private static HashMap canvases = new HashMap();

    public ObjectDrawShape(Location l, boolean f, Color c, DrawingCanvas canvas) {
        this.filled = f;
        this.hidden = false;
        this.setMyLocation(l);
        this.color = c == null ? DEFAULT_COLOR : c;
        this.shape = null;
        this.canvas = canvas;
        this.ready = false;
    }

    public ObjectDrawShape(Location l, double rotation, boolean f, Color c, DrawingCanvas canvas) {
        this.filled = f;
        this.hidden = false;
        this.setMyLocation(l);
        this.color = c == null ? DEFAULT_COLOR : c;
        this.shape = null;
        this.ROTATE_FLAG = true;
        this.angle = rotation;
        this.canvas = canvas;
        this.ready = false;
    }

    protected synchronized void ready() {
        if (this.ready) {
            return;
        }
        this.ready = true;
        if (this.canvas == null) {
            return;
        }
        ArrayList<ObjectDrawShape> list = (ArrayList<ObjectDrawShape>)canvases.get(this.canvas);
        if (list == null) {
            list = new ArrayList<ObjectDrawShape>();
            canvases.put(this.canvas, list);
        }
        list.add(this);
        this.depend(this.canvas);
        this.update();
    }

    protected void setMyLocation(Location loc) {
        if (this.location != null) {
            this.location.undepend(this);
        }
        this.location = loc;
        if (this.location != null) {
            this.location.depend(this);
        }
    }

    @Override
    public Shape getShape() {
        ObjectDrawObject.runUpdates();
        if (this.shape != null) {
            return this.shape;
        }
        this.shape = this.makeShape();
        return this.shape;
    }

    public void setMyShape(Shape shape) {
        this.shape = shape;
    }

    public abstract Shape makeShape();

    @Override
    public void update() {
        this.shape = null;
        super.update();
    }

    protected Location getMyLocation() {
        return this.location;
    }

    public static DrawableIterator getDrawables(DrawingCanvas canvas) {
        return new DrawableIterator((ArrayList)canvases.get(canvas));
    }

    public static void draw(DrawingCanvas canvas, Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setColor(canvas.getBackground());
        g.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
        DrawableIterator d = ObjectDrawShape.getDrawables(canvas);
        while (d.hasNext()) {
            DrawableInterface di = d.next();
            if (di == null || di.isHidden()) continue;
            try {
                di.draw(g);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void draw(DrawingCanvas canvas, Graphics2D g, double angle) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setColor(canvas.getBackground());
        g.fillRect(0, 0, canvas.getWidth(), canvas.getHeight());
        DrawableIterator d = ObjectDrawShape.getDrawables(canvas);
        while (d.hasNext()) {
            DrawableInterface di = d.next();
            if (di == null || di.isHidden()) continue;
            try {
                di.draw(g);
                di.setRotation(di.getRotation());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.ROTATE_FLAG) {
            g = (Graphics2D)g.create();
        }
        g.setColor(this.color);
        Shape s = this.getShape();
        if (s == null) {
            return;
        }
        if (this.ROTATE_FLAG) {
            this.internalRotate(g);
        }
        if (this.filled) {
            g.fill(s);
        } else {
            if (this instanceof DrawableStrokeInterface) {
                g.setStroke(((DrawableStrokeInterface)((Object)this)).getStroke());
            }
            if (s instanceof Polygon) {
                g.drawPolygon((Polygon)s);
            } else {
                g.draw(s);
            }
        }
        if (this.ROTATE_FLAG) {
            g.dispose();
        }
    }

    public void internalRotate(Graphics2D g) {
        if (this.shape != null && this.location != null && g != null) {
            g.rotate(Math.toRadians(this.angle), this.location.getDoubleX() + this.shape.getBounds2D().getWidth() / 2.0, this.location.getDoubleY() + this.shape.getBounds2D().getHeight() / 2.0);
        }
        this.update();
    }

    public static void staticRotate(Graphics2D g, double angle) {
        g.rotate(Math.toRadians(angle));
    }

    public static void clearCanvas(DrawingCanvas canvas) {
        DrawableIterator d = ObjectDrawShape.getDrawables(canvas);
        while (d.hasNext()) {
            ObjectDrawShape di = (ObjectDrawShape)d.next();
            di.setCanvas(null);
        }
    }

    public static void removeCanvas(DrawingCanvas canvas) {
        ObjectDrawShape.clearCanvas(canvas);
        canvases.remove(canvas);
    }

    private void setCanvas(DrawingCanvas c) {
        ArrayList<ObjectDrawShape> list;
        if (this.canvas != null) {
            this.undepend(this.canvas);
            list = (ArrayList)canvases.get(this.canvas);
            if (list != null) {
                list.remove(this);
            }
            this.canvas.update();
        }
        if (c != null) {
            list = (ArrayList<ObjectDrawShape>)canvases.get(c);
            if (list == null) {
                list = new ArrayList<ObjectDrawShape>();
                canvases.put(c, list);
            }
            list.add(this);
            this.depend(c);
        }
        this.canvas = c;
        this.update();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        if (this.canvas != null) {
            throw new IllegalStateException("An object that is already on a canvas cannot be added to another.");
        }
        this.setCanvas(c);
    }

    @Override
    public DrawingCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void hide() {
        this.hidden = true;
        this.update();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void move(double dx, double dy) {
        this.location.translate(dx, dy);
    }

    @Override
    public void moveTo(double x, double y) {
        this.move(x - this.location.getDoubleX(), y - this.location.getDoubleY());
    }

    @Override
    public void moveTo(Location point) {
        this.moveTo(point.getDoubleX(), point.getDoubleY());
    }

    @Override
    public void rotate(double toRotate) {
        this.ROTATE_FLAG = true;
        this.angle += toRotate;
        this.internalRotate((Graphics2D)this.canvas.getGraphics());
    }

    @Override
    public void setRotation(double newAngle) {
        this.ROTATE_FLAG = true;
        this.angle = newAngle;
        this.internalRotate((Graphics2D)this.canvas.getGraphics());
    }

    @Override
    public double getRotation() {
        return this.angle;
    }

    @Override
    public void removeFromCanvas() {
        this.setCanvas(null);
    }

    private int getDrawOrder() {
        if (this.canvas == null) {
            return -1;
        }
        return ((ArrayList)canvases.get(this.canvas)).indexOf(this);
    }

    private void setDrawOrder(int pos) {
        if (this.canvas == null) {
            return;
        }
        ArrayList list = (ArrayList)canvases.get(this.canvas);
        if (pos == -2 || pos >= list.size()) {
            pos = list.size() - 1;
        } else if (pos < 0) {
            pos = 0;
        }
        list.remove(this);
        list.add(pos, this);
        this.update();
    }

    @Override
    public void sendBackward() {
        this.setDrawOrder(this.getDrawOrder() - 1);
    }

    @Override
    public void sendForward() {
        this.setDrawOrder(this.getDrawOrder() + 1);
    }

    @Override
    public void sendToBack() {
        this.setDrawOrder(0);
    }

    @Override
    public void sendToFront() {
        this.setDrawOrder(-2);
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
        this.update();
    }

    public void setColor(Color c, float a) {
        this.color = new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        this.update();
    }

    @Override
    public void show() {
        this.hidden = false;
        this.update();
    }

    private String nameColor() {
        Color c = this.getColor();
        try {
            Field[] fields = Color.class.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                char start = f.getName().charAt(0);
                if (start >= 'A' && start <= 'Z' && c.equals(f.get(null))) {
                    return "Color." + f.getName();
                }
                ++i;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return "new Color(" + c.getRed() + ", " + c.getGreen() + ", " + c.getBlue() + (c.getAlpha() == 255 ? "" : ", " + this.getColor().getAlpha()) + ")";
    }

    @Override
    protected String toString(String middle) {
        return super.toString(String.valueOf(middle) + ", " + this.nameColor() + ", " + this.getCanvas());
    }
}

