/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Network;
import coffeedraw.NetworkThread;
import coffeedraw.ServerListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Server
extends NetworkThread {
    private final ServerSocketChannel serverSocket;
    private final ServerListener listener;
    private final MulticastAnnouncerChannel announcer;
    private final Runnable onLoad;

    Server(String name, Runnable onLoad) throws IOException {
        super(name);
        this.onLoad = onLoad;
        this.serverSocket = ServerSocketChannel.open();
        this.announcer = new MulticastAnnouncerChannel();
        this.listener = Network.serverListener;
        this.start();
    }

    public void sendMessage(String message, int channelID) {
        this.enqueueMessage(message, channelID);
    }

    public void sendMessage(String message) {
        this.enqueueMessage(message, -1);
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public boolean isRunning() {
        return super.isRunning();
    }

    @Override
    public void shutDown() {
        super.shutDown();
    }

    @Override
    void messageReceived(final int channel, final String channelName, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Server.this.listener.messageReceived(Server.this, channel, channelName, message);
            }
        });
    }

    @Override
    void channelClosed(final int channel, final String channelName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Server.this.listener.channelClosed(Server.this, channel, channelName);
            }
        });
    }

    @Override
    void channelReady(final int channel, final String channelName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Server.this.listener.channelOpened(Server.this, channel, channelName);
            }
        });
    }

    @Override
    boolean setup() {
        if (!super.setup()) {
            return false;
        }
        try {
            this.serverSocket.configureBlocking(false);
            InetSocketAddress isa = new InetSocketAddress(Network.gamePort);
            this.serverSocket.socket().bind(isa, 100);
            this.serverSocket.register(this.selector, 16, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.closeAll();
            return false;
        }
        try {
            this.announcer.setup();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Server.this.listener.serverStarted(Server.this);
                if (Server.this.onLoad != null) {
                    Server.this.onLoad.run();
                }
            }
        });
        return true;
    }

    @Override
    void tearDown() {
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Server.this.listener.serverStopped(Server.this);
            }
        });
        Network.closeServer(this);
        super.tearDown();
    }

    private class MulticastAnnouncerChannel
    implements NetworkThread.ChannelHandler,
    ActionListener {
        private final DatagramChannel channel = DatagramChannel.open();
        private final Timer timer = new Timer(100, this);
        private final ByteBuffer message;

        public MulticastAnnouncerChannel() throws IOException {
            this.message = ByteBuffer.wrap((String.valueOf(Server.this.getName()) + "\n" + Network.gameIdentifier).getBytes("ISO-8859-1"));
        }

        public void setup() throws IOException {
            this.channel.configureBlocking(false);
            this.channel.connect(new InetSocketAddress(Network.lobbyAddress, Network.lobbyPort));
            this.channel.register(Server.this.selector, 0, this);
            this.timer.start();
        }

        public void close() {
            this.timer.stop();
            try {
                this.channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void read() {
        }

        @Override
        public void write() {
            try {
                this.channel.write(this.message);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.close();
            }
            if (this.message.remaining() == 0) {
                this.message.rewind();
                Server.this.updateChannelLater(this.channel, 0, 4);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Server.this.updateChannelLater(this.channel, 4, 4);
            Server.this.selector.wakeup();
        }
    }
}

