/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawableInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.JDrawingCanvas;
import coffeedraw.Line;
import coffeedraw.Location;
import coffeedraw.ObjectDrawObject;
import coffeedraw.ObjectDrawShape;
import coffeedraw.TextWrappingLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Text
extends ObjectDrawShape
implements Drawable2DInterface,
TextWrappingLayout.TextRun,
Serializable {
    private DrawableInterface basis;
    private double alignH = -1.0;
    private double alignV = 1.0;
    private String text;
    private Font font = DEFAULT_FONT;
    private Text next;
    public static final int TOP = -1;
    public static final int BOTTOM = 1;
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int CENTER = 0;
    public static final Font DEFAULT_FONT = Font.decode("Times-PLAIN-12");

    public static String formatDecimal(double num) {
        return Text.formatDecimal(num, 4);
    }

    public static String formatDecimal(double num, int places) {
        int exponent;
        String sign = num < 0.0 ? "-" : "";
        String tail = "";
        double min = 1.0;
        int i = 0;
        while (i < places) {
            min /= 10.0;
            ++i;
        }
        if (num < 0.0) {
            num = -num;
        }
        if (num >= 1.0E9) {
            exponent = 0;
            while (num >= 10.0) {
                num /= 10.0;
                ++exponent;
            }
            tail = "e" + exponent + tail;
        } else {
            if (num <= 1.0E-10) {
                return "0";
            }
            if (num <= min) {
                exponent = 0;
                while (num < 1.0) {
                    num *= 10.0;
                    ++exponent;
                }
                tail = "e-" + exponent + tail;
            }
        }
        int ipart = (int)num;
        num -= (double)ipart;
        int place = 1;
        double adjust = 0.5;
        int i2 = 0;
        while (i2 < places) {
            place *= 10;
            adjust /= 10.0;
            ++i2;
        }
        int d = (int)((num + adjust) * (double)place) % 10;
        while (d == 0 && place > 1) {
            d = (int)((num + (adjust *= 10.0)) * (double)(place /= 10)) % 10;
        }
        if (place > 1) {
            while (place > 1) {
                tail = String.valueOf(d) + tail;
                d = (int)((num + adjust) * (double)(place /= 10)) % 10;
            }
            return String.valueOf(sign) + ipart + "." + tail;
        }
        return String.valueOf(sign) + ipart + tail;
    }

    private Text(Object text, double x, double y, DrawableInterface basis, Color color, DrawingCanvas canvas) {
        super(new Location(x, y), true, color, canvas);
        this.basis = basis;
        this.text = "" + text;
        if (basis instanceof ObjectDrawShape) {
            ((ObjectDrawObject)((Object)basis)).depend(this);
            if (basis instanceof Text) {
                Text b = (Text)basis;
                if (b.next != null) {
                    this.next = b.next;
                    this.next.basis = this;
                }
                b.next = this;
            }
        }
        this.update();
        this.ready();
    }

    public Text(Object text, double x, double y, Color color, DrawingCanvas canvas) {
        this(text, x, y, null, color, canvas);
    }

    private static ObjectDrawShape checkBasis(DrawableInterface basis) {
        if (!(basis instanceof ObjectDrawShape)) {
            String name = basis.getClass().getName();
            name = name.substring(name.indexOf(".") + 1);
            throw new IllegalArgumentException("Text is not able to lay itself out in a " + name + ".");
        }
        return (ObjectDrawShape)basis;
    }

    public Text(Object text, DrawableInterface basis, Color color, DrawingCanvas canvas) {
        this(text, Text.checkBasis(basis).getMyLocation().getX(), Text.checkBasis(basis).getMyLocation().getY(), basis, color, canvas);
    }

    public Text(Object text, Location origin, Color color, DrawingCanvas canvas) {
        this(text, origin.getDoubleX(), origin.getDoubleY(), color, canvas);
    }

    public Text(boolean text, double x, double y, Color color, DrawingCanvas canvas) {
        this("" + text, x, y, color, canvas);
    }

    public Text(boolean text, DrawableInterface basis, Color color, DrawingCanvas canvas) {
        this((Object)("" + text), basis, color, canvas);
    }

    public Text(boolean text, Location origin, Color color, DrawingCanvas canvas) {
        this((Object)("" + text), origin, color, canvas);
    }

    public Text(char text, double x, double y, Color color, DrawingCanvas canvas) {
        this("" + text, x, y, color, canvas);
    }

    public Text(char text, DrawableInterface basis, Color color, DrawingCanvas canvas) {
        this((Object)("" + text), basis, color, canvas);
    }

    public Text(char text, Location origin, Color color, DrawingCanvas canvas) {
        this((Object)("" + text), origin, color, canvas);
    }

    public Text(double text, double x, double y, Color color, DrawingCanvas canvas) {
        this(Text.formatDecimal(text), x, y, color, canvas);
    }

    public Text(double text, DrawableInterface basis, Color color, DrawingCanvas canvas) {
        this((Object)Text.formatDecimal(text), basis, color, canvas);
    }

    public Text(double text, Location origin, Color color, DrawingCanvas canvas) {
        this((Object)Text.formatDecimal(text), origin, color, canvas);
    }

    public Text(long text, double x, double y, Color color, DrawingCanvas canvas) {
        this("" + text, x, y, color, canvas);
    }

    public Text(long text, DrawableInterface basis, Color color, DrawingCanvas canvas) {
        this((Object)("" + text), basis, color, canvas);
    }

    public Text(long text, Location origin, Color color, DrawingCanvas canvas) {
        this((Object)("" + text), origin, color, canvas);
    }

    public Text(Object text, double x, double y, DrawingCanvas canvas) {
        this(text, x, y, null, canvas);
    }

    public Text(Object text, DrawableInterface basis, DrawingCanvas canvas) {
        this(text, basis, null, canvas);
    }

    public Text(Object text, Location origin, DrawingCanvas canvas) {
        this(text, origin.getDoubleX(), origin.getDoubleY(), canvas);
    }

    public Text(boolean text, double x, double y, DrawingCanvas canvas) {
        this(text, x, y, (Color)null, canvas);
    }

    public Text(boolean text, DrawableInterface basis, DrawingCanvas canvas) {
        this(text, basis, (Color)null, canvas);
    }

    public Text(boolean text, Location origin, DrawingCanvas canvas) {
        this(text, origin, (Color)null, canvas);
    }

    public Text(char text, double x, double y, DrawingCanvas canvas) {
        this(text, x, y, (Color)null, canvas);
    }

    public Text(char text, DrawableInterface basis, DrawingCanvas canvas) {
        this(text, basis, (Color)null, canvas);
    }

    public Text(char text, Location origin, DrawingCanvas canvas) {
        this(text, origin, (Color)null, canvas);
    }

    public Text(double text, double x, double y, DrawingCanvas canvas) {
        this(text, x, y, (Color)null, canvas);
    }

    public Text(double text, DrawableInterface basis, DrawingCanvas canvas) {
        this(text, basis, (Color)null, canvas);
    }

    public Text(double text, Location origin, DrawingCanvas canvas) {
        this(text, origin, (Color)null, canvas);
    }

    public Text(long text, double x, double y, DrawingCanvas canvas) {
        this(text, x, y, (Color)null, canvas);
    }

    public Text(long text, DrawableInterface basis, DrawingCanvas canvas) {
        this(text, basis, (Color)null, canvas);
    }

    public Text(long text, Location origin, DrawingCanvas canvas) {
        this(text, origin, (Color)null, canvas);
    }

    private Shape setEmptyShapes() {
        GeneralPath shape = new GeneralPath();
        this.setMyShape(shape);
        if (this.next != null) {
            this.next.setEmptyShapes();
        }
        return shape;
    }

    @Override
    public Shape makeShape() {
        if (this.getCanvas() == null) {
            return null;
        }
        Graphics2D g2 = (Graphics2D)((JDrawingCanvas)this.getCanvas()).getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.basis instanceof Text) {
            ((Text)this.basis).makeShape();
        } else if (this.basis == null || this.basis instanceof Line) {
            new TextWrappingLayout(this, this.alignH, this.alignV, null, g2.getFontRenderContext()).doLayout();
        } else {
            Shape basisShape = this.basis.getShape();
            new TextWrappingLayout(this, this.alignH, this.alignV, basisShape, g2.getFontRenderContext()).doLayout();
        }
        return this.getShape();
    }

    public void setAlignment(double horizontalAlign, double verticalAlign) {
        if (this.basis instanceof Text) {
            ((Text)this.basis).setAlignment(horizontalAlign, verticalAlign);
        } else {
            this.alignH = horizontalAlign;
            this.alignV = verticalAlign;
            this.update();
        }
    }

    public double getHorizontalAlignment() {
        if (this.basis instanceof Text) {
            return ((Text)this.basis).getHorizontalAlignment();
        }
        return this.alignH;
    }

    public double getVerticalAlignment() {
        if (this.basis instanceof Text) {
            return ((Text)this.basis).getVerticalAlignment();
        }
        return this.alignV;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    public void setFont(Font f) {
        this.font = f;
        this.update();
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t == null ? "" : t;
        this.update();
    }

    public void setFont(String fname) {
        this.setFont(new Font(fname, this.font.getStyle(), this.font.getSize()));
    }

    public void setPlain() {
        this.setFont(this.font.deriveFont(0));
    }

    public void setBold(boolean b) {
        this.setFont(this.font.deriveFont(b ? this.font.getStyle() | 1 : this.font.getStyle() & 0xFFFFFFFE));
    }

    public void setItalic(boolean i) {
        this.setFont(this.font.deriveFont(i ? this.font.getStyle() | 2 : this.font.getStyle() & 0xFFFFFFFD));
    }

    public void setFontSize(int size) {
        this.setFont(this.font.deriveFont((float)size));
    }

    public void setBold() {
        this.setBold(true);
    }

    public void setItalic() {
        this.setItalic(true);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.getShape().getBounds();
    }

    public Text getNext() {
        return this.next;
    }

    @Override
    public TextWrappingLayout.TextRun getNextRun() {
        return this.next;
    }

    private Line getBasisLine() {
        if (this.basis instanceof Line) {
            return (Line)this.basis;
        }
        if (this.basis instanceof Text) {
            return ((Text)this.basis).getBasisLine();
        }
        return null;
    }

    private Location getBasisLocation() {
        if (this.basis == null) {
            return this.getMyLocation();
        }
        if (this.basis instanceof Text) {
            return ((Text)this.basis).getBasisLocation();
        }
        return null;
    }

    @Override
    public void setShape(Shape shape) {
        Line line = this.getBasisLine();
        if (line != null) {
            double x = line.getStart().getDoubleX();
            double y = line.getStart().getDoubleY();
            double dx = line.getEnd().getDoubleX() - x;
            double dy = line.getEnd().getDoubleY() - y;
            double length = line.getStart().distanceTo(line.getEnd());
            AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
            transform.rotate(Math.atan2(dy, dx));
            transform.translate(length * (this.getHorizontalAlignment() + 1.0) / 2.0, 0.0);
            shape = transform.createTransformedShape(shape);
        } else {
            Location loc = this.getBasisLocation();
            if (loc != null) {
                AffineTransform transform = AffineTransform.getTranslateInstance(loc.getDoubleX(), loc.getDoubleY());
                shape = transform.createTransformedShape(shape);
            }
        }
        this.setMyShape(shape);
    }

    private DrawingCanvas getBasisCanvas() {
        if (this.basis == null) {
            return this.getCanvas();
        }
        if (this.basis instanceof Text) {
            return ((Text)this.basis).getBasisCanvas();
        }
        return this.basis.getCanvas();
    }

    @Override
    public void update() {
        DrawingCanvas c = this.getBasisCanvas();
        if (c != this.getCanvas()) {
            if (c == null) {
                this.removeFromCanvas();
            } else {
                this.addToCanvas(c);
            }
        }
        if (this.next != null) {
            this.updateForward();
        }
        this.updateBackward();
    }

    private void updateForward() {
        if (this.next != null) {
            this.next.updateForward();
        }
        super.update();
    }

    private void updateBackward() {
        if (this.basis instanceof Text) {
            ((Text)this.basis).updateBackward();
        }
        super.update();
    }

    public Text getPrevious() {
        if (this.basis instanceof Text) {
            return (Text)this.basis;
        }
        return null;
    }

    public DrawableInterface getBasis() {
        if (this.basis instanceof Text) {
            return ((Text)this.basis).getBasis();
        }
        return this.basis;
    }

    private String escapeText() {
        String s = "";
        int i = 0;
        while (i < this.text.length()) {
            char c = this.text.charAt(i);
            s = c == '\\' ? String.valueOf(s) + "\\\\" : (c == '\"' ? String.valueOf(s) + "\\\"" : (c == '\n' ? String.valueOf(s) + "\\n" : (c == '\t' ? String.valueOf(s) + "\\t" : (c == '\r' ? String.valueOf(s) + "\\r" : String.valueOf(s) + c))));
            ++i;
        }
        return "\"" + s + "\"";
    }

    @Override
    public int getX() {
        return this.getLocation().getX();
    }

    @Override
    public int getY() {
        return this.getLocation().getY();
    }

    @Override
    public double getDoubleX() {
        return this.getLocation().getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return this.getLocation().getDoubleY();
    }

    @Override
    public Location getLocation() {
        if (this.basis == null) {
            return this.getMyLocation();
        }
        if (this.basis instanceof Text) {
            return ((Text)this.basis).getLocation();
        }
        return ((ObjectDrawShape)this.basis).getMyLocation();
    }

    @Override
    public int getWidth() {
        return (int)(this.getBounds().getWidth() + 0.5);
    }

    @Override
    public int getHeight() {
        return (int)(this.getBounds().getHeight() + 0.5);
    }

    @Override
    public double getDoubleWidth() {
        return this.getBounds().getWidth();
    }

    @Override
    public double getDoubleHeight() {
        return this.getBounds().getHeight();
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return this.getBounds().intersects(other.getBounds());
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        if (this.basis instanceof Text) {
            ((Text)this.basis).next = this.next;
        }
        if (this.next != null) {
            this.next.alignH = this.alignH;
            this.next.alignV = this.alignV;
            this.next.basis = this.basis;
            this.next.update();
        } else if (this.basis instanceof Text) {
            ((Text)this.basis).update();
        }
        this.basis = null;
        this.next = null;
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        if (this.basis == null) {
            this.getMyLocation().translate(dx, dy);
        } else {
            ((ObjectDrawShape)this.basis).move(dx, dy);
        }
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        if (this.getShape() == null) {
            return false;
        }
        return this.getShape().getBounds2D().contains(point.getX(), point.getY());
    }

    @Override
    public String toString() {
        return this.toString(String.valueOf(this.escapeText()) + ", " + this.basis);
    }
}

