/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;

public class TextWrappingLayout {
    private TextRun start;
    private double alignV;
    private double alignH;
    private Shape shape;
    private FontRenderContext context;
    private double endPadding = 4.0;
    private static final double MIN_ERROR = 0.5;
    private static final int WORKING = 0;
    private static final int GROW = 1;
    private static final int TEXT_END = 2;
    private static final int LINE_END = 3;
    public static final double ALIGN_TOP = -1.0;
    public static final double ALIGN_BOTTOM = 1.0;
    public static final double ALIGN_LEFT = -1.0;
    public static final double ALIGN_RIGHT = 1.0;
    public static final double ALIGN_CENTER = 0.0;

    public TextWrappingLayout(TextRun start, double alignH, double alignV, Shape shape, FontRenderContext frc) {
        this.start = start;
        this.alignV = alignV;
        this.alignH = alignH;
        this.shape = shape;
        this.context = frc;
    }

    public void setEndPadding(double padding) {
        this.endPadding = padding;
    }

    private boolean doLayoutOnArc() {
        int end;
        TextRun run = this.start;
        String text = "";
        while (run != null) {
            text = String.valueOf(text) + run.getText();
            run = run.getNextRun();
        }
        if (text.length() == 0) {
            this.writeLayout(null);
            return true;
        }
        AttributedString string = new AttributedString(text);
        int offset = 0;
        run = this.start;
        while (run != null) {
            string.addAttribute(TextAttribute.FONT, run.getFont(), offset, offset + run.getText().length());
            offset += run.getText().length();
            run = run.getNextRun();
        }
        String[] lines = text.split("\n");
        int start = end = text.length();
        double height = 0.0;
        TextLayout layout = null;
        int j = lines.length - 1;
        while (j >= 0) {
            String line = lines[j];
            end = start;
            start -= line.length();
            while (start < end && Character.isWhitespace(text.charAt(start))) {
                ++start;
            }
            while (start < end && Character.isWhitespace(text.charAt(end))) {
                --end;
            }
            if (start != end) {
                layout = new TextLayout(string.getIterator(null, start, end), this.context);
                height += (double)(layout.getAscent() + layout.getDescent() + layout.getLeading());
            }
            --j;
        }
        height -= (double)layout.getLeading();
        this.writeLayout(null);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean doLayoutNoShape() {
        run = this.start;
        text = "";
        while (run != null) {
            text = String.valueOf(text) + run.getText();
            run = run.getNextRun();
        }
        if (text.length() == 0) {
            this.writeLayout(null);
            return true;
        }
        string = new AttributedString(text);
        offset = 0;
        run = this.start;
        while (run != null) {
            len = run.getText().length();
            if (len > 0) {
                string.addAttribute(TextAttribute.FONT, run.getFont(), offset, offset + len);
                offset += len;
            }
            run = run.getNextRun();
        }
        path = new GeneralPath();
        paths = new ArrayList<GeneralPath>();
        run = this.start;
        runEndOffset = run.getText().length();
        while (runEndOffset == 0) {
            run = run.getNextRun();
            runEndOffset = run.getText().length();
        }
        offset = 0;
        top = 0.0;
        spacing = 0.0;
        layout = null;
        ** GOTO lbl63
        {
            if (c == '\n') {
                top += spacing;
            }
            ++offset;
            do {
                if (offset < text.length() && Character.isWhitespace(c = text.charAt(offset))) continue block3;
                if (offset == text.length()) {
                    paths.add(path);
                    break block3;
                }
                endOffset = text.indexOf("\n", offset);
                endOffset = endOffset == -1 ? text.length() : ++endOffset;
                layout = new TextLayout(string.getIterator(null, offset, endOffset), this.context);
                transform = AffineTransform.getTranslateInstance(-layout.getBounds().getMinX() - (1.0 + this.alignH) * layout.getBounds().getWidth() / 2.0, top + (double)layout.getAscent());
                while (offset < endOffset) {
                    end = Math.min(runEndOffset, endOffset);
                    if (offset != end) {
                        runLayout = new TextLayout(string.getIterator(null, offset, end), this.context);
                        path.append(runLayout.getOutline(transform), false);
                        transform.translate(runLayout.getAdvance(), 0.0);
                        offset = end;
                    }
                    if (offset != runEndOffset) continue;
                    run = run.getNextRun();
                    paths.add(path);
                    if (run == null) continue;
                    runEndOffset += run.getText().length();
                    path = new GeneralPath();
                }
                top += (double)(layout.getAscent() + layout.getDescent() + layout.getLeading());
                spacing = (layout.getAscent() + layout.getDescent()) / 2.0f + layout.getLeading();
lbl63:
                // 2 sources

            } while (run != null);
        }
        transform = AffineTransform.getTranslateInstance(0.0, -(1.0 + this.alignV) * (top -= (double)layout.getLeading()) / 2.0);
        run = this.start;
        offset = 0;
        while (run != null) {
            run.setShape(transform.createTransformedShape((Shape)paths.get(offset)));
            run = run.getNextRun();
            ++offset;
        }
        return true;
    }

    private boolean layoutInRect(Rectangle2D rect) {
        HashMap map = this.tryLayout(rect.getMinY() + this.endPadding);
        double top = this.getMapTop(map);
        double bottom = this.getMapBottom(map);
        double height = bottom - top;
        double wiggleRoom = rect.getHeight() - 2.0 * this.endPadding - height;
        AffineTransform transform = AffineTransform.getTranslateInstance(0.0, (1.0 + this.alignV) * wiggleRoom / 2.0);
        this.writeLayout(map, transform);
        return this.isFullLayout(map);
    }

    public boolean doLayout() {
        WordInfo info = this.getFirstWord(this.start, 0);
        if (!info.exists) {
            this.writeLayout(null);
            return true;
        }
        if (this.shape == null) {
            return this.doLayoutNoShape();
        }
        if (this.shape instanceof Arc2D && ((Arc2D)this.shape).getArcType() == 0) {
            return this.doLayoutOnArc();
        }
        if (this.shape instanceof Rectangle2D) {
            return this.layoutInRect((Rectangle2D)this.shape);
        }
        Rectangle2D firstLine = this.placeWord(info.width, info.height, -1.0);
        if (firstLine == null) {
            this.writeLayout(null);
            return false;
        }
        double minY = firstLine.getMinY();
        HashMap map = this.tryLayout(minY);
        if (this.alignV == -1.0 || !this.isFullLayout(map)) {
            this.writeLayout(map);
            return this.isFullLayout(map);
        }
        double top = this.shape.getBounds2D().getMinY();
        double bottom = this.shape.getBounds2D().getMaxY();
        double maxY = this.placeWord(info.width, info.height, 1.0).getMinY();
        double align = (1.0 + this.alignV) / 2.0;
        HashMap bestMap = map;
        double bestAlign = (this.getMapTop(map) - top) / (this.getMapTop(map) - top + bottom - this.getMapBottom(map));
        if (bestAlign > align) {
            this.writeLayout(map);
            return true;
        }
        boolean improved = true;
        while (improved) {
            improved = false;
            double jump = maxY - minY;
            while (!improved && jump > 2.0) {
                double y = minY + jump / 2.0;
                while (!improved && y < maxY) {
                    double actualAlign;
                    map = this.tryLayout(y);
                    if (this.isFullLayout(map) && Math.abs((actualAlign = (this.getMapTop(map) - top) / (this.getMapTop(map) - top + bottom - this.getMapBottom(map))) - align) < Math.abs(bestAlign - align)) {
                        bestAlign = actualAlign;
                        bestMap = map;
                        if (bestAlign > align) {
                            maxY = y;
                        } else {
                            minY = y;
                        }
                        improved = true;
                    }
                    y += jump;
                }
                jump /= 2.0;
            }
        }
        this.writeLayout(bestMap);
        return true;
    }

    private WordInfo getFirstWord(TextRun run, int offset) {
        WordInfo info = new WordInfo();
        String text = "";
        while (run != null) {
            text = run.getText();
            while (offset < text.length() && Character.isWhitespace(text.charAt(offset))) {
                if (text.charAt(offset) == '\n') {
                    ++info.newlines;
                }
                ++offset;
            }
            info.run = run;
            info.offset = offset;
            info.totalOffset += offset;
            if (offset != text.length()) break;
            run = run.getNextRun();
            offset = 0;
        }
        if (run == null) {
            info.exists = false;
            return info;
        }
        int i = offset;
        while (i < text.length() && !Character.isWhitespace(text.charAt(i))) {
            ++i;
        }
        text = text.substring(offset, i);
        AttributedString astr = new AttributedString(text);
        astr.addAttribute(TextAttribute.FONT, run.getFont());
        TextLayout layout = new TextLayout(astr.getIterator(), this.context);
        info.width = layout.getBounds().getWidth() + 2.0 * this.endPadding + 0.1;
        info.height = layout.getAscent() + layout.getDescent();
        return info;
    }

    private void expand(Rectangle2D rect, double minX, double maxX) {
        double mid;
        double y = rect.getMinY();
        double h = rect.getHeight();
        double x = rect.getMinX();
        double endX = rect.getMaxX();
        while (x - minX > 0.5) {
            mid = (x + minX) / 2.0;
            rect.setRect(mid, y, endX - mid, h);
            if (this.shape.contains(rect)) {
                x = mid;
                continue;
            }
            minX = mid;
        }
        endX = x;
        x = rect.getMaxX();
        while (maxX - x > 0.5) {
            mid = (x + maxX) / 2.0;
            rect.setRect(endX, y, mid - endX, h);
            if (this.shape.contains(rect)) {
                x = mid;
                continue;
            }
            maxX = mid;
        }
        rect.setRect(endX, y, x - endX, h);
    }

    private ArrayList getLine(Rectangle2D line) {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        double minWidth = line.getHeight() * 0.2 + 2.0 * this.endPadding;
        double jump = line.getWidth();
        while (jump > minWidth) {
            double x = jump / 2.0;
            while (x <= line.getWidth()) {
                ((Rectangle2D)rect).setRect(x + line.getMinX(), line.getMinY(), minWidth, line.getHeight());
                if (this.shape.contains(rect)) {
                    this.expand(rect, line.getMinX(), line.getMaxX());
                    ArrayList list = this.getLine(new Rectangle2D.Double(line.getMinX(), line.getMinY(), rect.getMinX() - line.getMinX(), line.getHeight()));
                    list.add(rect);
                    list.addAll(this.getLine(new Rectangle2D.Double(rect.getMaxX(), line.getMinY(), line.getMaxX() - rect.getMaxX(), line.getHeight())));
                    return list;
                }
                x += jump;
            }
            jump /= 2.0;
        }
        return new ArrayList();
    }

    private boolean lineHasSpace(Rectangle2D line, double width) {
        ArrayList rects = this.getLine(line);
        int i = 0;
        while (i < rects.size()) {
            Rectangle2D rect = (Rectangle2D)rects.get(i);
            if (rect.getWidth() >= width) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Rectangle2D placeWord(double width, double height, double align) {
        double minY = this.shape.getBounds2D().getMinY() + this.endPadding;
        double maxY = this.shape.getBounds2D().getMaxY() - height - this.endPadding;
        align = (1.0 + align) / 2.0;
        double bestY = minY * (1.0 - align) + maxY * align;
        double left = this.shape.getBounds2D().getMinX();
        double lineWidth = this.shape.getBounds2D().getWidth();
        Rectangle2D.Double bestLine = null;
        Rectangle2D.Double line = new Rectangle2D.Double();
        boolean improved = true;
        while (improved) {
            improved = false;
            double jump = maxY - minY;
            while (!improved && jump > 0.5) {
                double y = minY + jump / 2.0;
                while (!improved && y < maxY) {
                    ((Rectangle2D)line).setRect(left, y, lineWidth, height);
                    if (this.lineHasSpace(line, width)) {
                        bestLine = line;
                        line = new Rectangle2D.Double();
                        double off = Math.abs(y - bestY);
                        minY = Math.max(minY, bestY - off);
                        maxY = Math.min(maxY, bestY + off);
                        improved = true;
                    }
                    y += jump;
                }
                jump /= 2.0;
            }
        }
        return bestLine;
    }

    private LineLayout layoutLine(TextRun run, int offset, double top) {
        WordInfo first = this.getFirstWord(run, offset);
        run = first.run;
        offset = first.offset;
        LineLayout oldLine = new LineLayout(run, offset, first.height, top);
        while (oldLine.getStatus() == 1) {
            LineLayout newLine = new LineLayout(run, offset, oldLine.getGrowHeight(), top);
            if (newLine.getTotalOffset() < oldLine.getTotalOffset()) {
                return oldLine;
            }
            oldLine = newLine;
        }
        return oldLine;
    }

    private HashMap tryLayout(double minY) {
        double maxY = this.shape.getBounds2D().getMaxY() - this.endPadding;
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("Top", new Double(minY));
        int offset = 0;
        int totalChars = 0;
        TextRun run = this.start;
        double bottom = minY;
        while (minY < maxY) {
            LineLayout line = this.layoutLine(run, offset, minY);
            if (line.getLastRun() != run || line.getEndOffset() != offset) {
                bottom = line.getBottom();
            }
            line.writeToMap(map);
            if (line.getStatus() == 2) {
                map.put("Bottom", new Double(bottom));
                return map;
            }
            offset = line.getEndOffset();
            minY = line.getBottom();
            run = line.getLastRun();
            totalChars += line.getTotalOffset();
        }
        map.put("Bottom", new Double(bottom));
        map.put("Count", new Integer(totalChars));
        return map;
    }

    private double getMapBottom(HashMap map) {
        Double b = (Double)map.get("Bottom");
        if (b == null) {
            return Double.NaN;
        }
        return b;
    }

    private double getMapTop(HashMap map) {
        return (Double)map.get("Top");
    }

    private int getMapLength(HashMap map) {
        return (Integer)map.get("Count");
    }

    private boolean isFullLayout(HashMap map) {
        return map.get("Count") == null;
    }

    private void writeLayout(HashMap map) {
        this.writeLayout(map, null);
    }

    private void writeLayout(HashMap map, AffineTransform transform) {
        TextRun run = this.start;
        while (run != null) {
            Shape path;
            if (map == null || (path = (GeneralPath)map.get(run)) == null) {
                path = new GeneralPath();
            } else if (transform != null) {
                path = transform.createTransformedShape(path);
            }
            run.setShape(path);
            run = run.getNextRun();
        }
    }

    private class LineLayout {
        private TextRun firstRun;
        private TextRun lastRun;
        private int totalOffset;
        private int endOffset;
        private ArrayList shapes;
        private int status;
        private double growHeight;
        private double bottom;

        public LineLayout(TextRun firstRun, int startOffset, double height, double top) {
            this.firstRun = firstRun;
            this.shapes = new ArrayList();
            this.bottom = top + height;
            this.doLayout(startOffset, height, top);
        }

        public void doLayout(int offset, double height, double top) {
            int endOfRun;
            int limit;
            TextRun run = this.firstRun;
            String text = run.getText().substring(offset);
            while ((limit = text.indexOf("\n")) == -1 && (run = run.getNextRun()) != null) {
                text = String.valueOf(text) + run.getText();
            }
            if (limit < 0) {
                limit = text.length();
            }
            if (limit == 0) {
                this.status = 2;
                return;
            }
            AttributedString string = new AttributedString(text);
            run = this.firstRun;
            int pos = endOfRun = run.getText().length() - offset;
            string.addAttribute(TextAttribute.FONT, run.getFont(), 0, endOfRun);
            while ((run = run.getNextRun()) != null) {
                int len = run.getText().length();
                if (len <= 0) continue;
                string.addAttribute(TextAttribute.FONT, run.getFont(), pos, pos + len);
                pos += len;
            }
            LineBreakMeasurer measurer = new LineBreakMeasurer(string.getIterator(), TextWrappingLayout.this.context);
            GeneralPath path = new GeneralPath();
            this.shapes.add(path);
            double align = (1.0 + TextWrappingLayout.this.alignH) / 2.0;
            run = this.firstRun;
            this.lastRun = this.firstRun;
            this.status = 0;
            double leading = 0.0;
            ArrayList rects = TextWrappingLayout.this.getLine(new Rectangle2D.Double(TextWrappingLayout.this.shape.getBounds2D().getMinX(), top, TextWrappingLayout.this.shape.getBounds2D().getWidth(), height));
            int i = 0;
            while (i < rects.size() && this.status == 0) {
                TextLayout layout;
                Rectangle2D rect = (Rectangle2D)rects.get(i);
                float layoutWidth = (float)(rect.getWidth() - 2.0 * TextWrappingLayout.this.endPadding);
                pos = measurer.getPosition();
                if (pos < limit && !((double)layoutWidth < 0.2 * height) && (layout = measurer.nextLayout(layoutWidth, limit, true)) != null && pos != measurer.getPosition()) {
                    if ((double)(layout.getAscent() + layout.getDescent()) > height) {
                        this.status = 1;
                        this.growHeight = layout.getAscent() + layout.getDescent();
                        int minPos = pos;
                        int maxPos = measurer.getPosition();
                        while (maxPos - minPos > 1) {
                            int posLimit = (minPos + maxPos) / 2;
                            measurer.setPosition(pos);
                            layout = measurer.nextLayout(layoutWidth, posLimit, true);
                            if ((double)(layout.getAscent() + layout.getDescent()) > height) {
                                this.growHeight = layout.getAscent() + layout.getDescent();
                                maxPos = posLimit;
                                continue;
                            }
                            minPos = posLimit;
                        }
                        measurer.setPosition(pos);
                        layout = measurer.nextLayout(layoutWidth, minPos, true);
                    }
                    double width = layout.getBounds().getWidth();
                    leading = Math.max(leading, (double)layout.getLeading());
                    double padding = rect.getWidth() - width < 2.0 * TextWrappingLayout.this.endPadding ? (rect.getWidth() - width) / 2.0 : TextWrappingLayout.this.endPadding;
                    double x = -layout.getBounds().getMinX() + (1.0 - align) * (rect.getMinX() + padding) + align * (rect.getMaxX() - width - padding);
                    double y = rect.getMaxY() - (double)layout.getDescent();
                    AffineTransform transform = AffineTransform.getTranslateInstance(x, y);
                    this.totalOffset = measurer.getPosition();
                    if (this.totalOffset > endOfRun) {
                        measurer.setPosition(pos);
                        layout = measurer.nextLayout(layoutWidth, endOfRun, true);
                        while (measurer.getPosition() < this.totalOffset) {
                            path.append(layout.getOutline(transform), false);
                            this.lastRun = run = run.getNextRun();
                            int len = run.getText().length();
                            endOfRun += len;
                            path = new GeneralPath();
                            this.shapes.add(path);
                            transform.translate(layout.getAdvance(), 0.0);
                            layout = len > 0 ? measurer.nextLayout(layoutWidth, Math.min(endOfRun, this.totalOffset), true) : new TextLayout(" ", run.getFont(), TextWrappingLayout.this.context);
                        }
                    }
                    path.append(layout.getOutline(transform), false);
                    if (this.totalOffset >= limit) {
                        if (limit == text.length()) {
                            this.status = 2;
                        } else {
                            this.status = 3;
                            this.endOffset = this.totalOffset + this.lastRun.getText().length() - endOfRun;
                            WordInfo next = TextWrappingLayout.this.getFirstWord(this.lastRun, this.endOffset);
                            this.bottom += leading + (double)(next.newlines - 1) * (height / 2.0 + leading);
                            this.lastRun = next.run;
                            this.endOffset = next.offset;
                            this.totalOffset += next.totalOffset;
                            return;
                        }
                    }
                }
                ++i;
            }
            if (this.status == 0) {
                this.status = 3;
            }
            this.bottom += leading;
            this.endOffset = this.totalOffset + this.lastRun.getText().length() - endOfRun;
        }

        public void writeToMap(HashMap map) {
            TextRun run = this.firstRun;
            int i = 0;
            while (i < this.shapes.size()) {
                GeneralPath path = (GeneralPath)map.get(run);
                if (path == null) {
                    path = new GeneralPath();
                    map.put(run, path);
                }
                path.append((GeneralPath)this.shapes.get(i), false);
                ++i;
                run = run.getNextRun();
            }
        }

        public int getStatus() {
            return this.status;
        }

        public double getGrowHeight() {
            return this.growHeight;
        }

        public int getTotalOffset() {
            return this.totalOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public TextRun getLastRun() {
            return this.lastRun;
        }

        public double getBottom() {
            return this.bottom;
        }
    }

    public static class SimpleTextRun
    implements TextRun {
        private Font font;
        private Color color;
        private String text;
        private SimpleTextRun next;
        private Shape shape;

        public SimpleTextRun(String text, Font font, Color color) {
            this.text = text;
            this.font = font;
            this.color = color;
        }

        @Override
        public Font getFont() {
            return this.font;
        }

        @Override
        public TextRun getNextRun() {
            return this.next;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setShape(Shape shape) {
            this.shape = shape;
        }

        public void append(SimpleTextRun run) {
            if (this.next == null) {
                this.next = run;
            } else {
                this.next.append(run);
            }
        }

        public void prepareLayout(Shape shape, double alignH, double alignV, FontRenderContext frc) {
            new TextWrappingLayout(this, alignH, alignV, shape, frc).doLayout();
        }

        public void draw(Graphics2D g) {
            if (this.shape != null) {
                g.setColor(this.color);
                g.fill(this.shape);
            }
            if (this.next != null) {
                this.next.draw(g);
            }
        }
    }

    public static interface TextRun {
        public void setShape(Shape var1);

        public Font getFont();

        public String getText();

        public TextRun getNextRun();
    }

    private class WordInfo {
        public int newlines = 0;
        public int offset;
        public int totalOffset = 0;
        public TextRun run;
        public double width;
        public double height;
        public boolean exists = true;

        private WordInfo() {
        }
    }
}

