/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.DrawableStrokeInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.LocatableInterface;
import coffeedraw.Location;
import coffeedraw.ObjectDrawShape;
import coffeedraw.Text;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.HashMap;

public class Turtle
extends ObjectDrawShape
implements DrawableStrokeInterface,
LocatableInterface {
    private BasicStroke stroke;
    private boolean pen;
    private TurtleFill fill;
    private TurtleLine line;
    private ArrayList fills;
    private ArrayList lines;
    private double heading;
    private boolean turtleHidden;
    private Location internalLocation;
    private AffineTransform sketchTransform;
    private double sketchScale;
    private double sketchRotation;
    private Location sketchOrigin;
    private HashMap recolorings;
    private static final int STEP_SIZE = 40;
    private static final Shape DEFAULT_SHAPE = Turtle.defaultShape();
    private static double[] t = new double[4];

    public void hideTurtle() {
        this.turtleHidden = true;
        this.update();
    }

    public void showTurtle() {
        this.turtleHidden = false;
        this.update();
    }

    public boolean isTurtleHidden() {
        return this.turtleHidden;
    }

    public void close() {
        this.line.close();
        this.line = null;
    }

    public void penUp() {
        this.pen = false;
        this.line = null;
        this.update();
    }

    public void penDown() {
        this.pen = true;
        this.update();
    }

    public boolean isPenDown() {
        return this.pen;
    }

    public double getHeading() {
        return this.heading + this.sketchRotation;
    }

    public void setHeading(double heading) {
        this.heading = (heading - this.sketchRotation) % 360.0;
        this.update();
    }

    public void rt() {
        this.rt(90.0);
    }

    public void rt(double angle) {
        this.setHeading(this.getHeading() - angle);
    }

    public void lt() {
        this.lt(90.0);
    }

    public void lt(double angle) {
        this.setHeading(this.getHeading() + angle);
    }

    public void move() {
        this.move(40.0);
    }

    public void move(double distance) {
        double ang = -this.heading * Math.PI / 180.0;
        this.moveInternal(distance * Math.cos(ang), distance * Math.sin(ang));
    }

    public Turtle(double x, double y, Color color, DrawingCanvas canvas) {
        super(null, false, color, canvas);
        this.internalLocation = new Location(0.0, 0.0);
        this.setMyLocation(new TurtleLocation(x, y));
        this.pen = true;
        this.recolorings = new HashMap();
        this.heading = 0.0;
        this.stroke = DEFAULT_STROKE;
        this.turtleHidden = false;
        this.sketchOrigin = new TurtleLocation(x, y);
        this.sketchScale = 1.0;
        this.sketchRotation = 0.0;
        this.sketchTransform = new AffineTransform();
        this.clearSketch();
        this.rebuildTransform();
        this.ready();
    }

    public Turtle(Location start, Color color, DrawingCanvas canvas) {
        this(start.getDoubleX(), start.getDoubleY(), color, canvas);
    }

    public Turtle(double x, double y, DrawingCanvas canvas) {
        this(x, y, null, canvas);
    }

    public Turtle(Location start, DrawingCanvas canvas) {
        this(start, null, canvas);
    }

    public Turtle(Color color, DrawingCanvas canvas) {
        this(canvas.getWidth() / 2, canvas.getHeight() / 2, color, canvas);
    }

    public Turtle(DrawingCanvas canvas) {
        this((Color)null, canvas);
    }

    public Turtle(Turtle clone, DrawingCanvas canvas) {
        super(null, false, clone.getColor(), canvas);
        this.internalLocation = clone.internalLocation;
        this.setMyLocation(new TurtleLocation(clone.getDoubleX(), clone.getDoubleY()));
        this.pen = clone.pen;
        ArrayList activeFills = new ArrayList();
        this.fill = new TurtleFill(clone.fill);
        this.fills = new ArrayList();
        int i = 0;
        while (i < clone.fills.size() - activeFills.size()) {
            new TurtleFill((TurtleFill)clone.fills.get(i));
            ++i;
        }
        this.fills.addAll(activeFills);
        this.lines = new ArrayList();
        i = 0;
        while (i < clone.lines.size()) {
            new TurtleLine((TurtleLine)clone.lines.get(i));
            ++i;
        }
        if (clone.line != null) {
            this.line = (TurtleLine)this.lines.get(this.lines.size() - 1);
        }
        this.recolorings = new HashMap(clone.recolorings);
        this.heading = clone.heading;
        this.stroke = clone.stroke;
        this.turtleHidden = clone.turtleHidden;
        this.sketchOrigin = new TurtleLocation(clone.getSketchDoubleX(), clone.getSketchDoubleY());
        this.sketchScale = clone.sketchScale;
        this.sketchRotation = clone.sketchRotation;
        this.sketchTransform = clone.sketchTransform;
        this.update();
    }

    private void moveInternal(double dx, double dy) {
        if (this.line == null) {
            this.line = new TurtleLine();
        }
        this.internalLocation.translate(dx, dy);
        this.line.move();
        if (this.fill != null) {
            this.fill.moved();
        }
        this.update();
    }

    private void translateColor(Graphics2D g, Color c) {
        Color translation = (Color)this.recolorings.get(c);
        if (translation == null) {
            g.setColor(c);
        } else {
            g.setColor(translation);
        }
    }

    @Override
    public void draw(Graphics2D g) {
        TurtleDrawable draw;
        AffineTransform saveAT = g.getTransform();
        g.transform(this.sketchTransform);
        if (this.lines == null) {
            return;
        }
        int i = 0;
        while (i < this.fills.size()) {
            draw = (TurtleDrawable)this.fills.get(i);
            draw.draw(g);
            ++i;
        }
        i = 0;
        while (i < this.lines.size()) {
            draw = (TurtleDrawable)this.lines.get(i);
            draw.draw(g);
            ++i;
        }
        if (!this.turtleHidden) {
            Shape shape = this.makeTurtleShape();
            g.setStroke(this.stroke);
            this.translateColor(g, this.getColor());
            if (this.pen) {
                g.fill(shape);
            }
            g.draw(shape);
        }
        g.setTransform(saveAT);
    }

    private Shape makeTurtleShape() {
        double ang = this.heading * Math.PI / 180.0;
        double cos = Math.cos(ang);
        double sin = Math.sin(ang);
        AffineTransform n = new AffineTransform(cos, -sin, sin, cos, this.internalLocation.getDoubleX(), this.internalLocation.getDoubleY());
        return n.createTransformedShape(DEFAULT_SHAPE);
    }

    public static Shape defaultShape() {
        GeneralPath me = new GeneralPath();
        me.moveTo(0.0f, 0.0f);
        me.lineTo(-4.0f, -8.0f);
        me.lineTo(12.0f, 0.0f);
        me.lineTo(-4.0f, 8.0f);
        me.closePath();
        return me;
    }

    public void beginFill(Color fillColor) {
        new TurtleFill(fillColor);
    }

    public void endFill() {
        if (this.fill != null) {
            this.fill.pop();
        }
    }

    @Override
    public Shape makeShape() {
        TurtleDrawable draw;
        Area sketchShape = new Area();
        int i = 0;
        while (i < this.fills.size()) {
            draw = (TurtleDrawable)this.fills.get(i);
            draw.addShape(sketchShape);
            ++i;
        }
        i = 0;
        while (i < this.lines.size()) {
            draw = (TurtleDrawable)this.lines.get(i);
            draw.addShape(sketchShape);
            ++i;
        }
        return this.sketchTransform.createTransformedShape(sketchShape);
    }

    public void clearSketch() {
        this.fills = new ArrayList();
        this.lines = new ArrayList();
        this.fill = null;
        this.line = null;
        this.update();
    }

    public void setSketchRotation(double angle) {
        this.sketchRotation = angle % 360.0;
        this.rebuildTransform();
    }

    public void rotateSketch(double byAngle) {
        this.setSketchRotation(this.sketchRotation + byAngle);
    }

    public double getSketchRotation() {
        return this.sketchRotation;
    }

    public void moveSketch(double dx, double dy) {
        this.sketchOrigin.translate(dx, dy);
    }

    public void moveSketchTo(double x, double y) {
        this.moveSketch(x - this.sketchOrigin.getDoubleX(), y - this.sketchOrigin.getDoubleY());
    }

    public void moveSketchTo(Location point) {
        this.moveSketchTo(point.getDoubleX(), point.getDoubleY());
    }

    public int getSketchX() {
        return (int)(this.sketchOrigin.getDoubleX() + 0.5);
    }

    public int getSketchY() {
        return (int)(this.sketchOrigin.getDoubleY() + 0.5);
    }

    public double getSketchDoubleX() {
        return this.sketchOrigin.getDoubleX();
    }

    public double getSketchDoubleY() {
        return this.sketchOrigin.getDoubleY();
    }

    public Location getSketchLocation() {
        return this.sketchOrigin;
    }

    public void setSketchScale(double factor) {
        this.sketchScale = factor;
        this.rebuildTransform();
    }

    public void scaleSketch(double byFactor) {
        this.setSketchScale(this.sketchScale * byFactor);
    }

    public double getSketchScale() {
        return this.sketchScale;
    }

    public void recolorSketch(Color original, Color substitute) {
        this.recolorings.put(original, substitute);
    }

    private void rebuildTransform() {
        this.sketchTransform.setToIdentity();
        this.sketchTransform.translate(this.sketchOrigin.getDoubleX(), this.sketchOrigin.getDoubleY());
        this.sketchTransform.rotate(-this.sketchRotation * Math.PI / 180.0);
        this.sketchTransform.scale(this.sketchScale, this.sketchScale);
        this.update();
    }

    @Override
    public double getLineWidth() {
        return this.stroke.getLineWidth();
    }

    @Override
    public BasicStroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setLineWidth(double width) {
        this.stroke = new BasicStroke((float)width, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        this.line = null;
        this.update();
    }

    @Override
    public void setStroke(BasicStroke stroke) {
        this.stroke = stroke;
        this.line = null;
        this.update();
    }

    @Override
    public int getX() {
        return this.getLocation().getX();
    }

    @Override
    public int getY() {
        return this.getLocation().getY();
    }

    @Override
    public double getDoubleX() {
        return this.getLocation().getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return this.getLocation().getDoubleY();
    }

    @Override
    public Location getLocation() {
        return this.getMyLocation();
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        this.line = null;
        super.setColor(c);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        return this.getShape().contains(point.getDoubleX(), point.getDoubleY());
    }

    @Override
    public String toString() {
        return this.toString(String.valueOf(Text.formatDecimal(this.getDoubleX())) + ", " + Text.formatDecimal(this.getDoubleY()));
    }

    private abstract class TurtleDrawable {
        private TurtleDrawable() {
        }

        public abstract void addShape(Area var1);

        public abstract void draw(Graphics2D var1);
    }

    private class TurtleFill
    extends TurtleDrawable {
        private GeneralPath path;
        private TurtleFill next;
        private boolean outline;
        private Color fillColor;

        public TurtleFill(TurtleFill clone) {
            this.path = new GeneralPath(clone.path);
            this.fillColor = clone.fillColor;
            if (clone.next != null) {
                this.next = new TurtleFill(clone.next);
            }
            Turtle.this.fills.add(this);
        }

        public TurtleFill(Color fillColor) {
            this.path = new GeneralPath();
            this.path.moveTo((float)Turtle.this.internalLocation.getDoubleX(), (float)Turtle.this.internalLocation.getDoubleY());
            this.next = Turtle.this.fill;
            Turtle.this.fill = this;
            this.fillColor = fillColor;
            Turtle.this.fills.add(this);
        }

        public void pop() {
            Turtle.this.fill = this.next;
        }

        public void moved() {
            if (Turtle.this.pen) {
                this.path.lineTo((float)Turtle.this.internalLocation.getDoubleX(), (float)Turtle.this.internalLocation.getDoubleY());
            } else {
                this.path.closePath();
                this.path.moveTo((float)Turtle.this.internalLocation.getDoubleX(), (float)Turtle.this.internalLocation.getDoubleY());
            }
        }

        @Override
        public void draw(Graphics2D g) {
            Turtle.this.translateColor(g, this.fillColor);
            g.fill(this.path);
        }

        public boolean contains(Location point) {
            return this.path.contains(point.getDoubleX(), point.getDoubleY());
        }

        @Override
        public void addShape(Area shape) {
            shape.add(new Area(this.path));
        }
    }

    private class TurtleLine
    extends TurtleDrawable {
        private Color color;
        private GeneralPath path;
        private BasicStroke stroke;

        public TurtleLine(TurtleLine clone) {
            this.color = clone.color;
            this.stroke = clone.stroke;
            Turtle.this.lines.add(this);
            this.path = new GeneralPath(clone.path);
        }

        public TurtleLine() {
            this.color = Turtle.this.getColor();
            this.stroke = Turtle.this.stroke;
            Turtle.this.lines.add(this);
            this.path = new GeneralPath();
            this.path.moveTo((float)Turtle.this.internalLocation.getDoubleX(), (float)Turtle.this.internalLocation.getDoubleY());
        }

        public void move() {
            if (Turtle.this.pen) {
                this.path.lineTo((float)Turtle.this.internalLocation.getDoubleX(), (float)Turtle.this.internalLocation.getDoubleY());
            } else {
                this.path.moveTo((float)Turtle.this.internalLocation.getDoubleX(), (float)Turtle.this.internalLocation.getDoubleY());
            }
        }

        @Override
        public void draw(Graphics2D g) {
            Turtle.this.translateColor(g, this.color);
            g.setStroke(this.stroke);
            g.draw(this.path);
        }

        @Override
        public void addShape(Area shape) {
            shape.add(new Area(this.stroke.createStrokedShape(this.path)));
        }

        public void close() {
            this.path.closePath();
        }
    }

    private class TurtleLocation
    extends Location {
        public TurtleLocation(double x, double y) {
            super(x, y);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void translate(double dx, double dy) {
            super.translate(dx, dy);
            if (this == Turtle.this.sketchOrigin) {
                Turtle.this.rebuildTransform();
                return;
            }
            double[] dArray = t;
            synchronized (t) {
                Turtle.t[0] = dx;
                Turtle.t[1] = dy;
                try {
                    Turtle.this.sketchTransform.createInverse().transform(t, 0, t, 2, 1);
                    Turtle.this.moveInternal(t[2] + Turtle.this.sketchTransform.getTranslateX(), t[3] + Turtle.this.sketchTransform.getTranslateY());
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

