/*
 * Decompiled with CFR 0.152.
 */
package coffeedraw;

import coffeedraw.Drawable2DInterface;
import coffeedraw.DrawingCanvas;
import coffeedraw.Location;
import coffeedraw.ObjectDrawRectangularShape;
import coffeedraw.Text;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.util.HashMap;

public class VisibleImage
extends ObjectDrawRectangularShape {
    private Image image;
    private static HashMap observers = new HashMap();
    private boolean manualSize = true;

    public VisibleImage(Image image, double x, double y, double width, double height, DrawingCanvas canvas) {
        super(x, y, width, height, true, null, canvas);
        this.image = image;
        this.ready();
    }

    public VisibleImage(Image image, double x, double y, DrawingCanvas canvas) {
        this(image, x, y, VisibleImage.blockAndGetImageWidth(image), VisibleImage.blockAndGetImageHeight(image), canvas);
        this.manualSize = false;
    }

    public VisibleImage(Image image, Location point, double width, double height, DrawingCanvas canvas) {
        this(image, point.getDoubleX(), point.getDoubleY(), width, height, canvas);
    }

    public VisibleImage(Image image, Location point, DrawingCanvas canvas) {
        this(image, point.getDoubleX(), point.getDoubleY(), canvas);
        this.manualSize = false;
    }

    public VisibleImage(Image image, Location corner1, Location corner2, DrawingCanvas canvas) {
        this(image, corner1, corner2.getDoubleX() - corner1.getDoubleX(), corner2.getDoubleY() - corner1.getDoubleY(), canvas);
    }

    public int getImageWidth() {
        return VisibleImage.blockAndGetImageWidth(this.image);
    }

    public int getImageHeight() {
        return VisibleImage.blockAndGetImageHeight(this.image);
    }

    public static BufferedImage createBufferedCopy(Image image) {
        int width = VisibleImage.blockAndGetImageWidth(image);
        int height = VisibleImage.blockAndGetImageHeight(image);
        BufferedImage im = new BufferedImage(width, height, 2);
        im.getGraphics().drawImage(image, 0, 0, null);
        return im;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        if (!this.manualSize) {
            super.setSize(VisibleImage.blockAndGetImageWidth(image), VisibleImage.blockAndGetImageHeight(image));
        }
        this.update();
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.image != null) {
            VisibleImage.blockAndLoadImage(this.image);
            g.drawImage(this.image, this.getX(), this.getY(), this.getWidth(), this.getHeight(), null);
        }
    }

    @Override
    public Shape makeShape() {
        return new Rectangle2D.Double(this.getLocation().getDoubleX(), this.getLocation().getDoubleY(), this.getDoubleWidth(), this.getDoubleHeight());
    }

    private static int blockAndGetImageWidth(Image image) {
        if (image == null) {
            return 0;
        }
        VisibleImage.blockAndLoadImage(image);
        return image.getWidth(null);
    }

    private static int blockAndGetImageHeight(Image image) {
        if (image == null) {
            return 0;
        }
        VisibleImage.blockAndLoadImage(image);
        return image.getHeight(null);
    }

    private static BlockingImageObserver getObserver(Image image) {
        if (image == null) {
            return null;
        }
        BlockingImageObserver observer = (BlockingImageObserver)observers.get(image);
        if (observer == null) {
            observer = new BlockingImageObserver();
            observers.put(image, observer);
        }
        return observer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void blockAndLoadImage(Image image) {
        if (image == null || image instanceof RenderedImage) {
            return;
        }
        observer = VisibleImage.getObserver(image);
        if (image.getWidth(observer) <= 0) ** GOTO lbl16
        return;
lbl-1000:
        // 1 sources

        {
            try {
                var2_2 = observer;
                synchronized (var2_2) {
                    observer.wait();
                    continue;
                }
            }
            catch (InterruptedException var2_3) {
                // empty catch block
            }
lbl16:
            // 3 sources

            ** while (!observer.isDone())
        }
lbl17:
        // 1 sources

    }

    @Override
    public void setSize(double width, double height) {
        super.setSize(width, height);
        this.manualSize = true;
    }

    @Override
    public void setWidth(double w) {
        super.setWidth(w);
    }

    @Override
    public void setHeight(double h) {
        super.setHeight(h);
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public double getDoubleX() {
        return super.getDoubleX();
    }

    @Override
    public double getDoubleY() {
        return super.getDoubleY();
    }

    @Override
    public Location getLocation() {
        return super.getLocation();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public double getDoubleWidth() {
        return super.getDoubleWidth();
    }

    @Override
    public double getDoubleHeight() {
        return super.getDoubleHeight();
    }

    @Override
    public boolean overlaps(Drawable2DInterface other) {
        return super.overlaps(other);
    }

    @Override
    public void hide() {
        super.hide();
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public boolean isHidden() {
        return super.isHidden();
    }

    @Override
    public void addToCanvas(DrawingCanvas c) {
        super.addToCanvas(c);
    }

    @Override
    public void removeFromCanvas() {
        super.removeFromCanvas();
    }

    @Override
    public DrawingCanvas getCanvas() {
        return super.getCanvas();
    }

    @Override
    public void moveTo(Location point) {
        super.moveTo(point);
    }

    @Override
    public void moveTo(double x, double y) {
        super.moveTo(x, y);
    }

    @Override
    public void move(double dx, double dy) {
        super.move(dx, dy);
    }

    @Override
    public Color getColor() {
        return super.getColor();
    }

    @Override
    public void setColor(Color c) {
        super.setColor(c);
    }

    @Override
    public void setColor(Color c, float a) {
        super.setColor(c, a);
    }

    @Override
    public void sendForward() {
        super.sendForward();
    }

    @Override
    public void sendBackward() {
        super.sendBackward();
    }

    @Override
    public void sendToFront() {
        super.sendToFront();
    }

    @Override
    public void sendToBack() {
        super.sendToBack();
    }

    @Override
    public boolean contains(Location point) {
        return super.contains(point);
    }

    @Override
    public String toString() {
        String str = "new VisibleImage(" + this.image + ", " + Text.formatDecimal(this.getDoubleX()) + ", " + Text.formatDecimal(this.getDoubleY()) + ", ";
        if (this.getWidth() != this.getImageWidth() || this.getHeight() != this.getImageHeight()) {
            str = String.valueOf(str) + Text.formatDecimal(this.getDoubleWidth()) + ", " + Text.formatDecimal(this.getDoubleHeight()) + ", ";
        }
        str = String.valueOf(str) + this.getCanvas() + ")";
        return str;
    }

    private static class BlockingImageObserver
    implements ImageObserver {
        private boolean done = false;

        private BlockingImageObserver() {
        }

        public boolean isDone() {
            return this.done;
        }

        @Override
        public synchronized boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags | 0x20) == 32 || (infoflags | 0x40) == 64) {
                this.done = true;
                this.notifyAll();
                return false;
            }
            return true;
        }
    }
}

